<?php

namespace Comitium5\DesignerBundle\Manager\Layout;

use Comitium5\DesignerBundle\Factory\AbstractFactory;
use Comitium5\DesignerBundle\Manager\AbstractManager;
use Comitium5\DesignerBundle\Manager\Page\PageManager;
use Comitium5\DesignerBundle\Manager\Widget\WidgetManager;
use Comitium5\DesignerBundle\Model\Interfaces\Layout\LayoutPageWidgetInterface;
use Doctrine\Common\Persistence\ObjectManager;
use Doctrine\Common\Persistence\ObjectRepository;

/**
 * Class LayoutPageWidgetManager
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Manager\Layout
 */
class LayoutPageWidgetManager extends AbstractManager
{
    /**
     * @var WidgetManager
     */
    private $widgetManager;

    /**
     * @param AbstractFactory $factory
     * @param ObjectRepository $repository
     * @param ObjectManager $objectManager
     * @param WidgetManager $widgetManager
     */
    public function __construct(
        AbstractFactory $factory,
        ObjectRepository $repository,
        ObjectManager $objectManager,
        WidgetManager $widgetManager
    ) {
        $this->factory = $factory;
        $this->repository = $repository;
        $this->objectManager = $objectManager;
        $this->widgetManager = $widgetManager;
    }

    /**
     * @param $data
     * @param LayoutPageManager $layoutPageManager
     * @param LayoutManager $layoutManager
     * @param PageManager $pageManager
     *
     * @return mixed
     */
    public function fromArray(
        $data,
        LayoutPageManager $layoutPageManager,
        LayoutManager $layoutManager,
        PageManager $pageManager
    ) {
        try {
            $layoutPageWidget = $this->find(
                !empty($data['id']) ? $data['id'] : 0
            );
        } catch (\Exception $e) {
            $layoutPageWidget = $this->getFactory()->create();
        }

        $dateFields = array('startAt', 'endAt');
        $specificFields = array('layoutPage', 'widget');
        foreach (array_merge($specificFields, $dateFields) as $field) {
            if (isset($data[$field])) {
                if (in_array($field, $dateFields)) {
                    $data[$field] = Utils::getDateTime($data[$field]);
                } else {
                    $$field = $data[$field];
                    unset($data[$field]);
                }
            }
        }

        $layoutPageWidget->fromArray($data);
        if (!empty($layoutPage)) {
            $entity = $layoutPageManager
                ->fromArray($layoutPage, $layoutManager, $pageManager);
            $layoutPageWidget->setLayoutPage($entity);
        }
        if (!empty($widget)) {
            $entity = $this->widgetManager
                ->fromArray($widget);
            $layoutPageWidget->setWidget($entity);
        }

        return $layoutPageWidget;
    }

    /**
     * @param  LayoutPageWidgetInterface $item
     * @return LayoutPageWidgetInterface
     */
    public function cloneItem($item)
    {
        $entity = clone $item;

        $this->cloneHandler($entity, $item);
        $entity->setLayoutPage(null);

        return $entity;
    }
}
