<?php

namespace Comitium5\DesignerBundle\Helper;

/**
 * Class SlugStopWordsHelper
 *
 * @author David Carrascosa <david@bab-soft.com>
 *
 * @package Comitium5\DesignerBundle\Helper
 */
final class SlugStopWordsHelper
{
    const STOP_WORDS = [
        "a",
        "ací",
        "ah",
        "ahi",
        "ahí",
        "al",
        "als",
        "amb",
        "ans",
        "ante",
        "apa",
        "asi",
        "así",
        "aun",
        "aún",
        "b",
        "c",
        "d",
        "de",
        "del",
        "dels",
        "des",
        "desde",
        "e",
        "eh",
        "el",
        "él",
        "els",
        "em",
        "et",
        "etc",
        "f",
        "g",
        "gairebé",
        "gueno",
        "h",
        "i",
        "j",
        "k",
        "l",
        "la",
        "las",
        "le",
        "les",
        "li",
        "lo",
        "los",
        "m",
        "n",
        "ne",
        "o",
        "oh",
        "oi",
        "os",
        "p",
        "para",
        "pel",
        "pels",
        "per",
        "q",
        "qeu",
        "qual",
        "quals",
        "que",
        "qué",
        "què",
        "quiza",
        "quizá",
        "quizas",
        "quizás",
        "r",
        "s",
        "sa",
        "ses",
        "t",
        "ta",
        "tal",
        "tene",
        "ti",
        "ton",
        "tons",
        "tras",
        "u",
        "un",
        "una",
        "unas",
        "unes",
        "uno",
        "unos",
        "uns",
        "us",
        "v",
        "w",
        "x",
        "y",
        "z",
    ];

    const PRONOUNS_START = [
        "d'",
        "d’",
        "l'",
        "l’",
        "m'",
        "m’",
        "n'",
        "n’",
        "s'",
        "s’",
        "t'",
        "t’",
    ];

    const PRONOUNS_END = [
        "'han",
        "’han",
        "'ha",
        "’ha",
        "'he",
        "’he",
        "'hi",
        "’hi",
        "'ls",
        "’ls",
        "'l",
        "’l",
        "'m",
        "’m",
        "'ns",
        "’ns",
        "'n",
        "’n",
        "'s",
        "’s",
        "'t",
        "’t",
    ];

    /**
     * @param $string
     * @param array $extraStopWords
     *
     * @return string
     */
    public static function removeStopWords($string,array $extraStopWords = [])
    {
        $words = explode(' ', $string);

        $stopWords = array_merge(self::STOP_WORDS, $extraStopWords);

        $words = array_filter($words, function(&$word) use ($stopWords) {
            $word = self::removePronouns($word);

            return !in_array(mb_strtolower($word), $stopWords);
        });

        return implode(' ', $words);
    }

    /**
     * @param $word
     *
     * @return string
     */
    public static function removePronouns($word)
    {
        foreach (self::PRONOUNS_END as $item) {
            $word = preg_replace('/'.strtolower($item).'$/i', '', $word);
        }

        foreach (self::PRONOUNS_START as $item) {
            $word = preg_replace('/^'.strtolower($item).'/i', '', $word);
        }

        $word = str_replace(['\'', '’', '"'], '', $word);

        return $word;
    }
}
