<?php

namespace Comitium5\DesignerBundle\Form\Type\Suggest;

use Comitium5\DesignerBundle\Form\DataTransformer\ExternalDataBaseSuggestTransformer;
use Symfony\Bundle\FrameworkBundle\Routing\Router;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\Form\FormView;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\TextType;

/**
 * Class ExternalDataBaseSuggestType
 * @package ComitiumSuite\Bundle\AdminBundle\Form\Type
 */
class ExternalDataBaseSuggestType extends AbstractType
{
    /**
     * @var ExternalDataBaseSuggestTransformer
     */
    private $transformer;

    /**
     * @var Router
     */
    private $router;

    /**
     * ExternalDataBaseSuggestType constructor.
     * @param ExternalDataBaseSuggestTransformer $transformer
     * @param Router $router
     */
    public function __construct(
        ExternalDataBaseSuggestTransformer $transformer,
        Router $router
    )
    {
        $this->router = $router;
        $this->transformer = $transformer;
    }

    /**
     * @param FormBuilderInterface $builder
     * @param array                $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->addViewTransformer(
                $this->transformer
                    ->setStringConnection($options['string_connection'])
                    ->setSuggestQuery($options['suggest_query'])
                    ->setMultiple($options['multiple'])
                    ->setSeparator($options['separator'])
                    ->setMatchQuery($options['match_query'])
                    ->setMatchProperty($options['match_property'])
                    ->createConnection()
            );
    }

    /**
     * @param FormView      $view
     * @param FormInterface $form
     * @param array         $options
     */
    public function buildView(FormView $view, FormInterface $form, array $options)
    {
        if (empty($options['suggest_query']["id_key"])) {
            $options['suggest_query']["id_key"] = "id";
        }

        $view->vars['allow_clear'] = $options["required"] ? false : true;
        $view->vars['url'] = $this->router->generate($options['route'], array(), Router::ABSOLUTE_URL);
        $view->vars['string_connection'] = base64_encode($options['string_connection']);
        $view->vars['suggest_query'] = base64_encode(json_encode($options['suggest_query']));
        $view->vars['multiple'] = $options['multiple'];
        $view->vars['dropdownCssClass'] = $options['dropdownCssClass'];
        $view->vars['autoInitialize'] = $options['autoInitialize'];
        $view->vars['separator'] = $options['separator'];
        $view->vars['queryType'] = $options['queryType'];
    }

    /**
     * @param OptionsResolver $resolver
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver
            ->setRequired([
                'route',
                'string_connection',
                'suggest_query',
                'match_query',
                'autoInitialize',
                'dropdownCssClass',
            ])
            ->setDefined([
                "multiple",
                "match_property",
                "separator",
                "queryType",
            ])
            ->setDefaults([
                'route'            => "designer_suggest_external",
                'queryType'        => "suggest",
                'multiple'         => false,
                'match_property'   => "id",
                'autoInitialize'   => "true",
                'dropdownCssClass' => "",
                'separator'        => ",",
            ])
        ;
    }

    /**
     * @return string
     */
    public function getParent()
    {
        return TextType::class;
    }

    /**
     * @return string
     */
    public function getBlockPrefix()
    {
        return 'external_database_suggest';
    }
}
