<?php

namespace Comitium5\DesignerBundle\Form\Type\Breakpoint;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Comitium5\DesignerBundle\Model\BreakpointType as BPType;
use Symfony\Component\OptionsResolver\OptionsResolver;
/**
 * Class BreakpointType
 *
 * Joan Pont <joan.pont@bab-soft.com>
 * @package Comitium5\DesignerBundle\Form\Type\Breakpoint
 */
class BreakpointType extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array                $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('name', TextType::class, [
                'label' => 'breakpoint_admin.fields.name',
            ])
            ->add('minWidth', NumberType::class, [
                'required' => false,
                'label' => 'breakpoint_admin.fields.min_width',
            ])
            ->add('type', ChoiceType::class, [
                'label' => 'breakpoint_admin.fields.type',
                "choices_as_values" => true,
                'choices' => array(
                    'breakpoint_admin.types.lg' => BPType::DESKTOP,
                    'breakpoint_admin.types.xs'  => BPType::MOBILE,
                    'breakpoint_admin.types.sm' => BPType::PHABLET,
                    'breakpoint_admin.types.md'  => BPType::TABLET,
                ),
            ])
            ->add('submit', SubmitType::class, array('label' => 'cs_admin.designer.toolbar.save'));
    }

    /**
     * @param OptionsResolver $resolver
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver
            ->setDefaults([
                "unique" => true,
            ]);
    }

    /**
     * @return string
     */
    public function getBlockPrefix()
    {
        return 'designer_breakpoint';
    }
}