<?php

namespace Comitium5\DesignerBundle\Form\Type\Asset;

use Comitium5\DesignerBundle\Form\Type\AssetType;
use Comitium5\DesignerBundle\Model\AssetTypes;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\OptionsResolver\OptionsResolver;

/**
 * Class SingleAssetType
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Form\Type\Asset
 */
class SingleAssetType extends AbstractType
{
    /**
     * @param OptionsResolver $resolver
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'asset_type' => AssetTypes::IMAGE,
        ));
    }

    /**
     * @return string
     */
    public function getParent()
    {
        return AssetType::class;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'single_asset';
    }
}
