<?php

namespace Comitium5\DesignerBundle\Factory\View;

use Comitium5\DesignerBundle\Entity\View;
use Comitium5\DesignerBundle\Factory\AbstractFactory;
use Comitium5\DesignerBundle\Helper\Utils;

/**
 * Class ViewFactory
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Factory\View
 */
class ViewFactory extends AbstractFactory
{
    /**
     * @return View
     */
    public function create()
    {
        $view = new View();

        $view
            ->setCreatedAt(new \DateTime())
            ->setUuid(Utils::uuidV4());

        return $view;
    }
}
