<?php

namespace Comitium5\DesignerBundle\Factory\Search\Filter;

use Elastica\Query\BoolQuery;
use Elastica\Query\Match;

/**
 * Class IdentifiableShouldFilter
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Factory\Search\Filter
 */
class IdentifiableShouldFilter
{
    /**
     * @var int
     */
    private $id;

    /**
     * IdentifiableFilter constructor.
     *
     * @param int $id
     */
    public function __construct(int $id)
    {
        $this->id = $id;
    }

    /**
     * @param BoolQuery $boolQuery
     */
    public function __invoke(BoolQuery $boolQuery): void
    {
        $match = new Match();

        $match->setFieldQuery('id', $this->id);

        $this->addFilter($boolQuery, $match);
    }

    /**
     * @param BoolQuery $boolQuery
     * @param Match $match
     */
    protected function addFilter(BoolQuery $boolQuery, Match $match): void
    {
        $boolQuery->addShould($match);
    }
}
