<?php

namespace Comitium5\DesignerBundle\Entity;

use Comitium5\DesignerBundle\Model\Interfaces\Widget\WidgetGroupInterface;
use Comitium5\DesignerBundle\Model\Traits\DateTimeTrait;
use Comitium5\DesignerBundle\Model\Traits\EnabledTrait;
use Comitium5\DesignerBundle\Model\Traits\HierarchicalTrait;

/**
 * Class WidgetGroup
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Entity
 */
class WidgetGroup extends AbstractEntity implements WidgetGroupInterface
{
    use DateTimeTrait, EnabledTrait, HierarchicalTrait;

    /**
     * @var string
     */
    private $name;

    /**
     * @var string
     */
    private $description;

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param string $name
     *
     * @return $this|WidgetGroupInterface
     */
    public function setName(string $name): WidgetGroupInterface
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return string
     */
    public function getDescription(): string
    {
        return $this->description;
    }

    /**
     * @param string $description
     *
     * @return $this|WidgetGroupInterface
     */
    public function setDescription(string $description): WidgetGroupInterface
    {
        $this->description = $description;

        return $this;
    }
}
