<?php

namespace Comitium5\DesignerBundle\Entity;

use Comitium5\DesignerBundle\Model\Interfaces\Asset\AssetInterface;
use Comitium5\DesignerBundle\Model\Traits\IdentifiableTrait;

/**
 * Class Asset
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Entity
 */
class Asset implements AssetInterface
{
    use IdentifiableTrait;

    /**
     * @var string
     */
    private $type;

    /**
     * @var string
     */
    private $title;

    /**
     * @var string
     */
    private $url;

    /**
     * @var string
     */
    private $localeCode;

    /**
     * @var array|null
     */
    private $imageRelated;

    /**
     * @var string
     */
    private $path;

    /**
     * @var int
     */
    private $width;

    /**
     * @var int
     */
    private $height;

    /**
     * @var string
     */
    private $embed;

    /**
     * @var array
     */
    private $children;

    /**
     * @var int
     */
    private $usages;

    /**
     * Asset constructor.
     */
    public function __construct()
    {
        $this->type         = "";
        $this->title        = "";
        $this->url          = "";
        $this->localeCode   = "";
        $this->imageRelated = null;
        $this->path         = "";
        $this->embed        = "";
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return $this->type;
    }

    /**
     * @param string $type
     *
     * @return $this|mixed
     */
    public function setType(string $type)
    {
        $this->type = $type;

        return $this;
    }

    public function getTitle(): string
    {
        return $this->title;
    }

    /**
     * @param string $title
     *
     * @return $this|mixed
     */
    public function setTitle(string $title)
    {
        $this->title = $title;

        return $this;
    }

    public function getUrl(): string
    {
        return $this->url;
    }

    /**
     * @param string $url
     *
     * @return $this|mixed
     */
    public function setUrl(string $url)
    {
        $this->url = $url;

        return $this;
    }

    /**
     * @return string
     */
    public function getLocaleCode(): string
    {
        return $this->localeCode;
    }

    /**
     * @param string $localeCode
     *
     * @return $this|mixed
     */
    public function setLocaleCode(string $localeCode)
    {
        $this->localeCode = $localeCode;

        return $this;
    }

    /**
     * @return array|null
     */
    public function getImageRelated(): ?array
    {
        return $this->imageRelated;
    }

    /**
     * @param array|null $imageRelated
     *
     * @return $this
     */
    public function setImageRelated(?array $imageRelated)
    {
        $this->imageRelated = $imageRelated;

        return $this;
    }

    /**
     * @return string
     */
    public function getPath(): string
    {
        return $this->path;
    }

    /**
     * @param string $path
     *
     * @return mixed|void
     */
    public function setPath(string $path)
    {
        $this->path = $path;

        return $this;
    }

    /**
     * @return int|mixed
     */
    public function getWidth()
    {
        return $this->width;
    }

    /**
     * @param mixed $width
     *
     * @return $this
     */
    public function setWidth($width)
    {
        $this->width = $width;

        return $this;
    }

    /**
     * @return mixed|void
     */
    public function getHeight()
    {
        return $this->height;
    }

    /**
     * @param mixed $height
     *
     * @return $this
     */
    public function setHeight($height)
    {
        $this->height = $height;

        return $this;
    }

    /**
     * @return string
     */
    public function getEmbed(): string
    {
        return $this->embed;
    }

    /**
     * @param string $embed
     *
     * @return $this|mixed
     */
    public function setEmbed(string $embed)
    {
        $this->embed = $embed;

        return $this;
    }

    /**
     * @return array
     */
    public function getChildren(): array
    {
        return $this->children;
    }

    /**
     * @param array $children
     *
     * @return $this|mixed
     */
    public function setChildren(array $children)
    {
        $this->children = $children;

        return $this;
    }

    /**
     * @return int
     */
    public function getUsages(): int
    {
        return $this->usages;
    }

    /**
     * @param int $usages
     *
     * @return $this|mixed
     */
    public function setUsages(int $usages)
    {
        $this->usages = $usages;

        return $this;
    }
}
