<?php

namespace Comitium5\DesignerBundle\Entity;

use Comitium5\DesignerBundle\Model\Interfaces\IdentifiableInterface;
use Comitium5\DesignerBundle\Model\Traits\IdentifiableTrait;

/**
 * Class AbstractEntity
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Entity
 */
abstract class AbstractEntity implements IdentifiableInterface
{
    use IdentifiableTrait;

    public function __construct()
    {
        // do nothing
    }

    /**
     * @return string
     */
    public function __toString()
    {
        return (string) $this->id;
    }
}
