<?php

namespace Comitium5\DesignerBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

/**
 * This is the class that validates and merges configuration from your app/config files.
 *
 * To learn more see {@link http://symfony.com/doc/current/cookbook/bundles/configuration.html}
 */
class Configuration implements ConfigurationInterface
{
    /**
     * {@inheritdoc}
     */
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder();
        $rootNode = $treeBuilder->root('comitium5_designer');

        $rootNode
            ->children()
                ->scalarNode("cs_bundle_path")
                    ->isRequired()
                    ->defaultNull()
                ->end()
                ->scalarNode("cs_backend_url")
                    ->isRequired()
                    ->defaultNull()
                ->end()
                ->scalarNode("elastic_host")
                    ->isRequired()
                    ->defaultNull()
                ->end()
                ->scalarNode("elastic_port")
                    ->isRequired()
                    ->defaultNull()
                ->end()
                ->scalarNode("redis_host")
                    ->isRequired()
                    ->defaultNull()
                ->end()
                ->scalarNode("redis_scheme")
                    ->isRequired()
                    ->defaultNull()
                ->end()
                ->scalarNode("redis_port")
                    ->isRequired()
                    ->defaultNull()
                ->end()
                ->scalarNode("redis_database")
                    ->isRequired()
                    ->defaultNull()
                ->end()
                ->scalarNode("redis_password")
                    ->isRequired()
                    ->defaultNull()
                ->end()
            ->end();

        return $treeBuilder;
    }
}
