<?php

namespace Comitium5\DesignerBundle\DataFixtures\ORM\View;

use Comitium5\DesignerBundle\DataFixtures\Abstracts\AbstractFixture;
use Comitium5\DesignerBundle\Factory\View\ViewFactory;
use Doctrine\Common\Persistence\ObjectManager;

/**
 * Class ViewFixtures
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\DataFixtures\ORM\View
 */
class ViewFixtures  extends AbstractFixture
{
    /**
     * @param ObjectManager $manager
     */
    public function load(ObjectManager $manager)
    {
        if ($this->getEnvironment() !== 'prod') {
            $factory = new ViewFactory();

            foreach ($this->views() as $view) {
                $entity = $factory->create();

                $entity
                    ->setName($view["name"])
                    ->setContent(file_get_contents(__DIR__.$view["content"]));

                $manager->persist($entity);
            }

            $manager->flush();
        }
    }

    /**
     * @return \string[][]
     */
    private function views(): array
    {
        return [
            [
                "name" => "@Comitium/Designer/Templates/tmp/template1.html.twig",
                "content" => "/content/tmp_template1.html.twig",
            ],
            [
                "name" => "@Comitium/Designer/Templates/template1.html.twig",
                "content" => "/content/template1.html.twig",
            ],
            [
                "name" => "@Comitium/Designer/Templates/tmp/template2.html.twig",
                "content" => "/content/tmp_template2.html.twig",
            ],
            [
                "name" => "@Comitium/Designer/Layouts/layout1.html.twig",
                "content" => "/content/layout1.html.twig",
            ],
            [
                "name" => "@Comitium/Designer/Layouts/layout2.html.twig",
                "content" => "/content/layout2.html.twig",
            ],
            [
                "name" => "@Comitium/Designer/Templates/template2.html.twig",
                "content" => "/content/template2.html.twig",
            ],
        ];
    }
}
