<?php

namespace Comitium5\DesignerBundle\DataFixtures\ORM\Page;

use Comitium5\DesignerBundle\DataFixtures\Abstracts\AbstractFixture;
use Comitium5\DesignerBundle\DataFixtures\ORM\Template\TemplateFixtures;
use Doctrine\Common\DataFixtures\DependentFixtureInterface;
use Doctrine\Common\Persistence\ObjectManager;

/**
 * Class PageFixtures
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\DataFixtures\ORM\Page
 */
class PageFixtures extends AbstractFixture implements DependentFixtureInterface
{
    /**
     * @param ObjectManager $manager
     */
    public function load(ObjectManager $manager)
    {
        $factory = $this->container->get("designer.factory.page");

        foreach ($this->pages() as $page) {
            $entity = $factory->create();

            $entity
                ->setOriginId($page['id'])
                ->setTemplate($this->getReference($page["template"]))
            ;

            $manager->persist($entity);
        }

        $manager->flush();
    }

    /**
     * @return array
     */
    public function getDependencies()
    {
        return [
            TemplateFixtures::class,
        ];
    }

    /**
     * @return array[]
     */
    private function pages(): array
    {
        return [
            [
                "id" => 1,
                "template" => "template-home",
            ],
            [
                "id" => 2,
                "template" => "template-thematic",
            ],
            [
                "id" => 3,
                "template" => "template-thematic",
            ],
            [
                "id" => 4,
                "template" => "template-thematic",
            ],
            [
                "id" => 5,
                "template" => "template-article",
            ],
            [
                "id" => 6,
                "template" => "template-live-event",
            ],
            [
                "id" => 7,
                "template" => "template-search",
            ],
            [
                "id" => 8,
                "template" => "template-static",
            ],
            [
                "id" => 9,
                "template" => "template-static",
            ],
            [
                "id" => 10,
                "template" => "template-static",
            ],
            [
                "id" => 11,
                "template" => "template-newsletter",
            ],
            [
                "id" => 12,
                "template" => "template-static",
            ],
            [
                "id" => 13,
                "template" => "template-static",
            ],
            [
                "id" => 14,
                "template" => "template-static",
            ],
            [
                "id" => 15,
                "template" => "template-static",
            ],
            [
                "id" => 16,
                "template" => "template-static",
            ],
            [
                "id" => 17,
                "template" => "template-amp",
            ],
            [
                "id" => 18,
                "template" => "template-amp",
            ],
        ];
    }
}
