<?php

namespace Comitium5\DesignerBundle\Adapter\Search;

use Comitium5\DesignerBundle\Model\Interfaces\SearchClientInterface;
use Elastica\Client;
use Elastica\Search;

/**
 * Class ElasticSearchClient
 *
 * @author Oscar Jimenez <oscarjg19.developer@gmail.com>
 * @package Comitium5\DesignerBundle\Adapter\Search
 */
class ElasticSearchClient implements SearchClientInterface
{
    /**
     * @var Search
     */
    private $client;

    /**
     * ElasticSearchClient constructor.
     *
     * @param $host
     * @param $port
     */
    public function __construct(
        $host,
        $port
    ) {
        $this->client = new Search(
            new Client([
                'host' => $host,
                'port' => $port
            ])
        );
    }

    /**
     * @return Search
     */
    public function getClient(): Search
    {
        return $this->client;
    }
}