var Widgets = (function () {

    this.clicks = [];
    this.values = [];

    var setPath = function(path) {
        $('#admin_widget_source').val(path);
    };

    var update = function(_element) {
        updateOptionsValue();
        updateDisabled();

        _element.parents('ul').prev().text(_element.text());
    }

    var updateOptionsValue = function() {
        var target = $('#admin_widget_options');
        target.val(this.values.join('|'));

    };

    var updateDisabled = function() {
        var totalFiles = $('#widget-diff-files').find('.portlet').length;
        var _submit = $('#admin_widget_submit');

        if (this.clicks.length >= totalFiles || totalFiles === 0) {
            _submit.removeClass('disabled');
        } else {
            _submit.addClass('disabled');
        }
    };

    var bindFunctions = function() {
        var _this = this;
        var _diffElement = $('#widget-diff-files');

        _diffElement.find('[data-action="apply-diff"]').each(function(){
            $(this).on('click', function(e){
                var _id = $(this).data('id');

                if ($.inArray(_id,_this.clicks) === -1) {
                    _this.clicks.push(_id);
                }

                e.preventDefault();

                var value = $(this).data('value');

                _this.values.push(value);

                update($(this));
            });
        });

        _diffElement.find('[data-action="remove-diff"]').each(function(){
            $(this).on('click', function(e){

                var _id = $(this).data('id');

                if ($.inArray(_id,_this.clicks) === -1) {
                    _this.clicks.push(_id);
                }

                e.preventDefault();

                var value = $(this).data('value');

                var _index = $.inArray(value,_this.values);

                if (_index !== -1) {
                    _this.values.splice(_index, 1);
                }

                update($(this));
            });
        });
    };

    var displayDiffs = function(html) {
        $('#widget-diff-files').html(html);
    };

    return {
        init: function (selector, options) {
            var dropzone = new DropzoneCS(selector, options);

            $.each(dropzone.dropzones, function(k,el){
                var _dropzone = el[0].dropzone;

                _dropzone.on('success', function(file, response) {
                    setPath(response.path);
                    updateDisabled();
                });

                _dropzone.on('error', function(file, response){

                    file.previewElement.addEventListener("click", function() {
                        _dropzone.removeFile(file);
                    });

                    if (typeof response === "object") {
                        $('[data-dz-errormessage]').text(response.message);

                        if (response.displayDiff) {
                            setPath(response.path);
                            displayDiffs(response.html);
                            bindFunctions();
                            updateDisabled();
                        }
                    }
                });
            });
        }
    };
})();
