var Templates = (function () {

    function TemplateList(nestableSelector, nestableOptions){

        var _this = this;

        this.nestableOptions = nestableOptions||{};

        this.nestableOptions = $.extend(this.nestableOptions, {allowMoveAction:_this.allowMoveAction});

        this.nestableSelector = nestableSelector;

        this.toasterShowing = false;

        UINestable
            .init(this.nestableSelector, this.nestableOptions)
            .signals.onChange.add(function(e){
                _this.onChange(e);
            });

        this.bindFunctions();
    }

    TemplateList.prototype = {
        onChange: function(e) {
            var el = $(e.target);
            var treeData = $(this.nestableSelector).nestable('serialize');
            var parentData = this.getParentData(el);
            var elementData = this.buildElementData(el, true);

            //console.log(el.parent('.dd-list').children().index(el));
            //$(e).parents('.dd-item').index($(e));
            $.ajax({
                url: Routing.generate('admin_template_update_tree'),
                data: {
                    tree:treeData,
                    parent: parentData,
                    element: elementData
                },
                success: function() {},
                error: function(response) {}
            });


        },
        getParentData: function(element) {
            var parent = element.parents('.dd-item');

            return this.buildElementData(parent, false);
        },
        buildElementData: function(element, addPosition) {
            var position = element.parent('.dd-list').children().index(element);

            var object = {
                id: element.data('id'),
                type: element.data('type')
            };

            if (addPosition) {
                object.position = position> 0  ? position : 0
            }

            return object;
        },
        toggleIcon: function(element) {
            var nestedLevel = element.parentsUntil(this.selector,'.dd-list').length;

            if (nestedLevel == this.nestableOptions.maxDepth) {
                element.removeClass('group').addClass('template');
            } else {
                element.removeClass('template').addClass('group');
            }
        },
        allowMoveAction: function(prev, el, nestable) {
            var parentType  = prev.data('type');
            var elementType = el.data('type');

            if (parentType == 2 && elementType == 1) {

                if (nestable.toasterShowing == false) {

                    showToastrNotification('warning',Translator.trans('admin_template.index.messages.error.ident_group'),{}, function(){
                        nestable.toasterShowing = true;

                        setTimeout(function(){ nestable.toasterShowing = false }, 5000);
                    });
                }

                return false;
            }

            return true;
        },
        toggleEnabled: function(data) {
            $.ajax({
                url: Routing.generate('admin_template_update_state'),
                data: data,
                method: 'POST',
                success: function(response) {
                    if (response.updated) {
                        var message = '';

                        if (data.state) {
                            if (data.type == 1) {
                                message = 'admin_template.index.messages.success.template_group_enabled';
                            } else {
                                message = 'admin_template.index.messages.success.template_enabled';
                            }
                        } else {
                            if (data.type == 1) {
                                message = 'admin_template.index.messages.success.template_group_disabled';
                            } else {
                                message = 'admin_template.index.messages.success.template_disabled';
                            }
                        }

                        showToastrNotification('success',Translator.trans(message));
                    }
                },
                error: function() {
                    showToastrNotification('error',Translator.trans('admin_template.index.messages.error.enabled_disabled'));
                }
            });
        },
        bindFunctions: function() {

            var _this = this;

            $(this.nestableSelector).on('click','[data-action="enabled-template"]', function() {

                var data = {};
                var node  = $(this).parents('.dd-item');

                data.id    = node.data('id');
                data.state = Number($(this).find('[type="checkbox"]').is(':checked'));
                data.type  = node.data('type');

                _this.toggleEnabled(data);
            });
        },
        initializeLibraries: function() {
            $(this.nestableSelector).find('[type="checkbox"]').each(function(){
                $(this).bootstrapSwitch();
            });

            this.bindFunctions();
        }
    };

    function TemplateForms(formName) {
        var _this = this;
        this.form = $('form[name="'+formName+'"]');

        this.aceEditorInit = false;
        this.aceEditor = new AceEditor();

        FormWizard.onChange.add(function(tab, navigation, index) {

            if(index == 4 && navigation.children(':last').hasClass('disabled')){
                $("#form-wizard form")
                    .find('[data-btn-type="continue"]').hide()
                    .end()
                    .find('.button-submit').show()
                ;
            }

            if(index == 4 && !_this.aceEditorInit){
                _this.aceEditor.init("#admin_template_html","twig");
                _this.aceEditorInit = true;
            }
        });

        this.form.on("submit", function(e){
            orderSelectsByTable();
        });

        this.bindFunctions();
        orderSelectsByTable();
    }

    var orderSelectsByTable = function() {
        $('[data-action="add-row"]').each(function(){
            var tableId  = $(this).data("table");
            var selectId = $(this).data("select-id");
            var target = $(this).data("target");

            $('#'+ tableId)
                .find('[data-action="remove-row"]')
                .each(function(){
                    var entityId = $(this).data("id");
                    $('#'+target+' option[value="'+entityId+'"]').prop('selected',true).appendTo('#'+target);
                });
        });
    };

    var bindRemoveFunction = function(element, selectId, parentId, callback) {
        var id = element.data('id');

        $('#'+parentId+' option[value="'+id+'"]').prop('selected',false);

        $('#'+selectId+' option[value="'+id+'"]').prop('disabled',false);

        element.closest('tr').remove();

        $("#"+selectId).select2('enable');

        callback.call(this);
    };

    var hideRowOptions = function(callback) {
        $('#parent-options').fadeOut(300, function(){
            if (typeof callback == "function") {
                callback.call(this);
            }
        });
    };

    var showRowOptions = function() {
        $('#parent-options').fadeIn(300, function(){
            $('#admin_template_parent')
                .prop({'disabled':true, 'required':false})
                .val('')
                .select2('val',"");
        });
    };

    TemplateForms.prototype = {
        bindFunctions: function() {
            var _this = this;

            $('#admin_template_useBootstrapRows').on('switchChange.bootstrapSwitch', function(event, state) {
                if (state === true) {
                    showRowOptions();
                } else {
                    hideRowOptions();
                }
            });


            $('a[href="#html"], a[href="#step5"]').on('shown.bs.tab', function (e) {
                if(!_this.aceEditorInit){
                    _this.aceEditor.init("#admin_template_html","twig");
                    _this.aceEditorInit = true;
                }
            });

            $('[name="parent_radio"]', _this.form).on('click', function(e){
                var target = $(e.target);

                if (target.attr('id') === 'blank-template') {
                    showRowOptions();
                    _this.changeParent(null);

                } else {
                    hideRowOptions(function(){
                        _this.clearParentOptions();
                    });
                }
            });

            $('[data-action="add-row"]').on('click', function(e){
                e.preventDefault();

                var _el = $(this);
                var selectId = $(this).data("select-id");
                var data = $('#'+ selectId).select2('data');
                var target = $(this).data("target");
                var table = $(this).data("table");

                $('#'+target+' option[value="'+data.id+'"]').prop('selected',true).appendTo('#'+target);

                $('#'+selectId+' option[value="'+data.id+'"]').prop('disabled',true);

                _this.changeOptionStatusCssSelect(selectId, _el);

                var tr = $("<tr>");

                var cssName = $("<td>").html(data.text);

                var actionSpan = $("<span>",{class:'opts'});

                var actionLink = $("<a>", {class:'btn btn-circle btn-icon-only yellow-gold','data-action':'remove-row','data-id':data.id});

                var actionIcon = $("<i>", {class:'fa fa-minus'});

                actionLink.html(actionIcon);

                actionSpan.html(actionLink);

                actionLink.on("click", function(){
                    bindRemoveFunction($(this),selectId,target, function(){
                        _el.prop('disabled',false);
                        _this.changeOptionStatusCssSelect(selectId, _el);
                    });
                });

                var actionTd = $("<td>", {class:'text-center'}).html(actionSpan);

                tr.append(cssName).append(actionTd);

                $("#"+table+" tbody").append(tr);

                orderSelectsByTable();
            });

            $('.cs_templates table').on('click', '[data-action="remove-row"]', function(e){
                e.preventDefault();

                var selectId = $(this).data("select-id");
                var target = $(this).data("target");
                var _el = $(this);

                bindRemoveFunction($(this),selectId,target, function(){
                    _el.prop('disabled',false);
                    $('[data-action="add-row"]').prop('disabled',false);
                    _this.changeOptionStatusCssSelect(selectId, _el);
                });

                orderSelectsByTable();
            });

            $("#admin_template_parent").on('change', function(){
                _this.changeParent($(this).val());
            });
        },
        clearParentOptions: function() {
            //$('#admin_template_width').val('');
            //$('#admin_template_columns').val('');
            //$('#admin_template_gutterWidth').val('');
            $('#admin_template_parent').prop({'disabled':false, 'required':true});
        },
        changeParent: function(parent){
            var _this = this;

            _this.updateTemplateCodeBase(parent);
            _this.disableBreakpointsStep(parent);

            if(parent){
                $("input[name*='breakpoints']").bootstrapSwitch('state', false, false);
            }
        },
        updateTemplateCodeBase: function(parent){
            if(parent == null){
                $.get(Routing.generate('admin_template_code_base'))
                    .success(function(data){
                        $("textarea[id*=html]").val(data.code);
                    })
            }
        },
        disableBreakpointsStep: function(parent){

            var breakpointsTab = $('a[href="#step6"]');

            if(breakpointsTab.length){

                var attr_method = (parent) ? 'removeAttr' : 'attr';
                var class_method = (parent) ? 'addClass' : 'removeClass';

                breakpointsTab[attr_method]('data-toggle','tab');
                breakpointsTab.closest('li')[class_method]('disabled');
            }else{

                var stepState = (parent) ? 'disable' : 'enable';

                $("#form-wizard form").bootstrapWizard(stepState,4);
            }
        },
        changeOptionStatusCssSelect: function(selectorId, el){
            var optionsEnabled = $("#"+selectorId+" option:enabled");

            if(optionsEnabled.length){
                var nextOptionSelected = optionsEnabled.first().val();
                $("#"+selectorId).select2("val",nextOptionSelected);
            }else{
                $("#"+selectorId).select2('disable');
                el.prop('disabled',true);
            }
        }
    };

    return {
        initList: function(selector,options) {
            var _templateList = new TemplateList(selector, options);

            Pagination.onChange.add(function() {
                _templateList.initializeLibraries();
            });
        },
        initForms: function(formName) {
            new TemplateForms(formName);
        }
    }
})();
