var Gallery = (function () {

    var isAllowed = function(widget, deniedWidgetIds) {
        var widgetId = widget.attr("id");

        return $.inArray(widgetId, deniedWidgetIds) === -1;
    }

    return {
        //main function to initiate the module
        initWidget: function(widget, advancedFilter) {
            $("#sortable_portlets", widget).on('sortupdate', function (e) {
                Gallery.updateIndexes(widget);
            });


            var _dropzone = AssetsHelper.getDropzone($('.dropzone', widget));
            _dropzone.on('queuecomplete', function() {

                Gallery.updateIndexes(widget);
            });

            Gallery.widget = widget;

            if (advancedFilter){
                Gallery.initAdvancedFilter(advancedFilter);
            }
        },
        init: function (advancedFilter, deniedWidgetIds) {
            PortletDraggable.init();

            AssetsHelper.signals.onWidgetInit.add(function(widget) {
                if (isAllowed(widget, deniedWidgetIds) === false) {
                    return false;
                }

                Gallery.initWidget(widget, advancedFilter);
            });

            AssetsHelper.signals.onNewAdd.add(function(widget, element) {
                if (isAllowed(widget, deniedWidgetIds) === false) {
                    return false;
                }

                var input = AssetsHelper.findInputById(widget, element.data('id-content'));

                element.addClass('portlet portlet-sortable');

                element.find('.asset-title').addClass('portlet-sortable-empty');

                input.val('-1|-1|' + input.val());

                PortletDraggable.init();
            });

            AssetsHelper.signals.onNewRemove.add(function(widget) {
                if (isAllowed(widget, deniedWidgetIds) === false) {
                    return false;
                }

                Gallery.updateIndexes();
            });

            AssetsHelper.signals.onLibraryAdd.add(function(widget, origObject, destOject) {
                if (isAllowed(widget, deniedWidgetIds) === false) {
                    return false;
                }

                destOject.addClass('portlet portlet-sortable');

                destOject.find('.asset-title').addClass('portlet-sortable-empty');

                PortletDraggable.init();

                var input = AssetsHelper.findInputById(widget, origObject.data('id-content'));

                input.val('-1|-1|' + input.val());

                Gallery.updateIndexes();
            });

            AssetsHelper.signals.onLibraryRemove.add(function(widget, origObject, destOject) {

                Gallery.updateIndexes();
            });
        },
        advancedFilter: null,
        initAdvancedFilter: function(advancedFilter) {
            this.advancedFilter = advancedFilter;
            this.advancedFilter.init(this.widget);
        },
        getAdvancedFilter: function() {
            return this.advancedFilter;
        },
        getPosition: function(widget, id) {
            return Gallery.getValues(widget, id).slice(0, 1);
        },
        setPosition: function(widget, id, value) {
            Gallery.setValues(widget, id, 0, value);
        },
        getGalleryAsset: function(widget, id) {
            return Gallery.getValues(widget, id).slice(1, 2);
        },
        setGalleryAsset: function(widget, id, value) {
            Gallery.setValues(widget, id, 1, value);
        },
        getAsset: function(widget, id) {
            return Gallery.getValues(widget, id).slice(2, 3);
        },
        setAsset: function(widget, id, value) {
            Gallery.setValues(widget, id, 2, value);
        },
        getValues: function(widget, id) {
            var input = AssetsHelper.findInputById(widget, id);
            return input.val().split('|');
        },
        setValues: function(widget, id, index, value) {
            var input = AssetsHelper.findInputById(widget, id);
            var values = input.val().split('|');
            values[index] = value;
            input.val(values.join('|'));
            return values;
        },
        updateIndexes: function (widget) {
            var _dropzone = AssetsHelper.getDropzone($('.dropzone', widget));
            var elements = _dropzone.elementContainer.find('.asset-wrapper');

            elements.each(function (i, e) {
                var element = $(e);
                var id = element.data('id-content');

                Gallery.setPosition(_dropzone.widgetContainer, id, element.index() + 1);
            });

        },
        widget: null
    };
})();
