var DynamicForms = (function() {

    var initializeLibraries = function(element) {

        // Spinners
        var spinners = $(element).find(".gf-spinner");

        spinners.each(function(){
            var _input = $(this).find("input");
            var min = _input.data("min")||0;
            var max = _input.data("max")||9999;

            $(this).spinner({value: '', min: min, max: max});
        });


        $('.touchspin-input').each(function(){
            var _this = $(this);

            _this.TouchSpin({
                min: _this.data("min")||0,
                max: _this.data("max")||100,
                step: _this.data("step")||0.01,
                decimals: _this.data("decimals")||2
            });
        });

        $(element).on('click', '[data-action="loop"]', function(e){
            var loopTargetId = $(this).attr('data-target');
            loop($(loopTargetId));
        });

        $(element).on('click', '[data-action="remove-loop"]', function(e){
            var loopTargetId = $(this).attr('data-target');
            removeLoop($(loopTargetId));
        });

        $('form').on('submit', function() {
            // Order groups
            $('[data-position]').each(function(k){
                $(this).val(k+1);
            });
        });

        initSortables('body');
        $('[data-role="loop-block"]').each(function() {
            initToggleButton($(this));
        });
    };

    var loop = function(elem) {

        var newLoop = elem.clone();
        var random  = _.random(300, 1000);

        $(newLoop).find('[data-new-loop]').val("1");
        $(newLoop).attr('id', 'loop_' + random);

        // Add remove button
        if ($(newLoop).find('[data-action="remove-loop"]').length == 0 ) {
            $(newLoop).find('.actions').append('<a class="btn btn-icon-only btn-circle red" data-action="remove-loop" data-target="#loop_'+random+'"><i class="fa fa-times"></i></a>');
        }

        $(newLoop).find('.actions :first').attr('data-target', '#loop_' + random);

        replaceProp(newLoop,'input',['name','id'], random);
        replaceProp(newLoop,'textarea',['name','id'], random);
        replaceProp(newLoop,'label',['for'], random);
        replaceProp(newLoop,'select',['name','id'], random);
        replaceProp(newLoop,'fieldset',['id','data-name'], random);
        replaceProp(newLoop,'[data-action="remove-loop"]',['data-target'], random, true);

        //Assets replace
        replaceProp(newLoop,'.assets-widget',['id'], random);
        replaceProp(newLoop,'[data-toggle="tab"]',['href'], random);
        replaceProp(newLoop,'.tab-pane',['id'], random);

        elem.parent().append(newLoop);

        // Init libraries
        initSwitch(newLoop);
        initSpinners(newLoop);
        initTouchSpin(newLoop);
        initCalendars(newLoop);
        initSelect2(newLoop);
        initAssets(newLoop);
        initCkEditor(newLoop);
        initToggleButton(newLoop);
    };

    var removeLoop = function(elem) {
        var children= elem.parents('[data-sortable="loop-sortable"]').find('.portlet').length;

        if (children > 1) {
            $(elem).fadeOut('slow', function(){
                $(this).remove();
            });
        } else {
            showToastrNotification('error', Translator.trans('cms_articles.messages.error.loop'));
        }
    };

    var replaceProp = function(elem, selector, attr, random, strict) {
        $(elem).find(selector).each(function(k,v){

            _.map(attr, function(a){
                var n  = $(v).attr(a);
                if (n) {
                    var pattern = /\d+/g;
                    var currentValue = pattern.exec(n);
                    var nn = strict ? n.replace(/\d+/g, random): n.replace(/\d+/g, parseInt(currentValue) + random);

                    $(v).attr(a,nn);
                    resetValues($(v), selector);
                }
            });

        });
    };

    var resetValues = function(elem, selector) {
        if (selector == 'input' && elem.attr('type') != 'hidden') {
            elem.val('');
        }

        if (selector == 'textarea' && elem.attr('type') != 'hidden') {
            elem.empty();
        }
    };

    var initSortables = function(element) {

        $(element).find('[data-sortable="loop-sortable"]').each(function(k,v){
            //PortletDraggable.init($(v));
            $(v).sortable({
                connectWith: ".portlet",
                items: ".portlet",
                opacity: 0.8,
                coneHelperSize: true,
                placeholder: 'portlet-sortable-placeholder',
                forcePlaceholderSize: true,
                tolerance: "pointer",
                helper: "clone",
                tolerance: "pointer",
                forcePlaceholderSize: !0,
                helper: "clone",
                cancel: ".portlet-sortable-empty",
                revert: 250, // animation in milliseconds
                update: function(b, c) {
                    if (c.item.prev().hasClass("portlet-sortable-empty")) {
                        c.item.prev().before(c.item);
                    }
                },
                start: function (event, ui)
                {
                    ui.item.find("textarea").each(function(k,v){
                        var id = $(v).attr("id");

                        if (id) {
                            CKEDITOR.instances[id].destroy();
                        }
                    });
                },
                stop: function (event, ui)
                {
                    ui.item.find("textarea").each(function(k,v){
                        var id = $(v).attr("id");

                        if (id) {
                            CKEDITOR.replace(id);
                        }
                    });
                }
            });
        });

    };

    var initSwitch = function(element) {
        // Switch

        if ($(element).find('[type="checkbox"]').length) {
            $(element).find('[type="checkbox"]').each(function(k,v){
                //Move out bootstrap switch to reset containers
                var parent = $(this).parents('.bootstrap-switch');
                parent.removeClass("bootstrap-switch");
                parent.empty().append($(this));
                $(this).bootstrapSwitch("state", false, true);
            });
        }
    };

    var initSpinners = function(element) {
        if ($(element).find(".gf-spinner").length) {
            $(element).find(".gf-spinner").spinner({value: 1, min: 1, max: 9999});
        }
    };

    var initTouchSpin = function(element) {

        //Remove controls
        if ($(element).find(".touchspin-input").length) {
            $(element).find(".touchspin-input").each(function (k, v) {
                $(v).parent('.bootstrap-touchspin').empty().append(v);

                $(v).TouchSpin({
                    min: 0,
                    max: 100,
                    step: 0.01,
                    decimals: 2
                });
            });
        }
    };

    var initCalendars = function(element) {

        if ($(element).find(".form_datetime").length) {
            $(element).find(".form_datetime").each(function(k,v){

                var format = $(v).attr('data-format')||"dd/mm/yyyy - hh:ii";

                $(v).datetimepicker({
                    autoclose: true,
                    isRTL: Metronic.isRTL(),
                    format: format,
                    pickerPosition: (Metronic.isRTL() ? "bottom-right" : "bottom-left"),
                    language: 'ca'
                });
            });

        }
    };

    var initSelect2 = function(element) {

        $(element).find("select").each(function (k, v) {
            $(v).parent().empty().append(v);
            $(v).val("");
            $(v).select2();
        });

        if ($(element).find($("[data-suggest]"))) {
            var target = $(element).find($("[data-suggest]"));
            target.parent().find(".select2-container").remove();
            target.val("");
            Suggest
                .setSelector(target)
                .init();
        }

    };

    var initAssets = function(element) {
        if ($(element).find(".assets-widget").length) {
            AssetsHelper.initWidget(element);
            AssetsHelper.reset(element);
        }
    };

    var initCkEditor = function(element) {
        if ($(element).find("textarea").length) {
            $(element).find("textarea").each(function (k, v) {

                $(v).val("");
                $(v).next().remove();
                $(v).next('script').remove();

                CKEDITOR.replace($(v).attr('id'),CKEDITOR.config);
            });
        }
    };

    var initToggleButton = function(element) {
        var loopBtn = $('[data-role="loop-btn"]'),
            loopElement = $('[data-role="loop-element"]');

        $('[data-role="loop-btn"]', element).on('click', function() {
            var loopElement = $('[data-role="loop-fields"]', $(this).closest('[data-role="loop-block"]'));
            if(loopElement.is(':hidden')) {
                $(this).removeClass('closed').addClass('opened');
                loopElement.slideDown();
            } else {
                $(this).removeClass('opened').addClass('closed');
                loopElement.slideUp();
            }
        });
    }

    return {
        init: function() {
            initializeLibraries('body');
        }
    };
})();
