var Modal = Class.extend({
	init: function()
	{
		this.target = null;
	},
	getTarget: function()
	{
		return this.target;
	},
	definedTarget: function()
	{
		return (
			this.getTarget() &&
			this.getTarget().length > 0
		);
	},
	render: function(specificClass)
	{
		this.target = jQuery('<div/>', {
			class: Modal.MODAL_CLASS,
			html: jQuery('<div/>', {
				class: Modal.MODAL_CLASS+'-inner'
			})
		});
		this.target.append(jQuery('<div/>', {
			class: Modal.MODAL_CLASS+'-bg'
		}));
		jQuery(
			'.'+Modal.MODAL_CLASS+'-inner',
			this.target
		).append(jQuery('<div/>', {
			class: Modal.MODAL_CLASS+'-content'
		}));
		jQuery(
			'.'+Modal.MODAL_CLASS+'-inner',
			this.target
		).append(jQuery('<div/>', {
			class: Modal.MODAL_CLASS+'-options'
		}));
		if (specificClass) {
			this.target.addClass(specificClass);
		}

		return this.target;
	},
	addContent: function(content)
	{
		if (this.definedTarget()) {
			jQuery(
				'.'+Modal.MODAL_CLASS+'-content',
				this.getTarget()
			).append(content);
			jQuery(
				'.'+Modal.MODAL_CLASS+'-content',
				this.getTarget()
			).show();
		}
	},
	addOption: function(type, html, title, specificClass, callBack)
	{
		var option = jQuery('<a/>', {
			href: '#'
		});

		if (this.definedTarget()) {
			switch (type) {
				case Modal.ACCEPT_OPTION:
					option.addClass(Modal.MODAL_CLASS+'-accept');
					if (!title) {
						title = Translator.trans('cs_admin.designer.modal.accept');
					}
					break;
				case Modal.CANCEL_OPTION:
					option.addClass(Modal.MODAL_CLASS+'-cancel');
					if (!title) {
						title = Translator.trans('cs_admin.designer.modal.cancel');
					}
					break;
				case Modal.YES_OPTION:
					option.addClass(Modal.MODAL_CLASS+'-yes');
					if (!title) {
						title = Translator.trans('cs_admin.designer.modal.yes');
					}
					break;
				case Modal.NO_OPTION:
					option.addClass(Modal.MODAL_CLASS+'-no');
					if (!title) {
						title = Translator.trans('cs_admin.designer.modal.no');
					}
					break;
			}

			if (callBack) {
				option.click(callBack);
			}
			if (specificClass) {
				option.addClass(specificClass);
			}
			if (!html) {
				html = title;
			}
			option.html(html);
			jQuery(
				'.'+Modal.MODAL_CLASS+'-options',
				this.getTarget()
			).append(option);
			jQuery(
				'.'+Modal.MODAL_CLASS+'-options',
				this.getTarget()
			).show();
		}

		return option;
	},
	remove: function()
	{
		var $this = this;

		if ($this.definedTarget()) {
			$this.getTarget()
				.parents('body')
				.off('keyup');
			$this.hide(function() {
				$this.getTarget().remove();
			});
		}
	},
	show: function(callBack, allowCancel)
	{
		if (this.definedTarget()) {
			this.getTarget().parents('body').css('overflow', 'hidden');
			this.getTarget()
				.fadeIn('fast', callBack);
			if (allowCancel) {
				this.allowCancel();
			}
		}
	},
	hide: function(callBack)
	{
		if (this.definedTarget()) {
			this.getTarget()
				.fadeOut('fast', callBack);
			this.getTarget().parents('body').css('overflow', 'inherit');
		}
	},
	allowCancel: function()
	{
		var $this = this;

		if ($this.definedTarget()) {
			jQuery(
				'.'+Modal.MODAL_CLASS+'-bg',
				$this.getTarget()
			).off('click').click(function(event){
				event.preventDefault();
				if (jQuery(
					'.'+Modal.MODAL_CLASS+'-cancel',
					$this.getTarget()
				).length > 0) {
					jQuery(
						'.'+Modal.MODAL_CLASS+'-cancel',
						$this.getTarget()
					).click();
				} else {
					$this.remove();
				}
			});

			$this.getTarget()
				.parents('body')
				.off('keyup')
				.keyup(function(event){
					if (event.which == 27) {
						event.preventDefault();
						jQuery(
							'.'+Modal.MODAL_CLASS+'-bg',
							$this.getTarget()
						).click();
					}
				});
		}
	}

});
Modal.ACCEPT_OPTION = 1;
Modal.CANCEL_OPTION = 2;
Modal.YES_OPTION = 3;
Modal.NO_OPTION = 4;
Modal.MODAL_CLASS = 'csmodal';
