var CommonDesigner = (function(){

    var bindFavorites = function(element, fromSearch) {

        var _el = element ? element : $('[data-type="favorite"]');

        _el.on("click", function(){
            var _this = $(this);
            var isFavorite = _this.hasClass("fa-star");
            var entityId = _this.parents("li").data("widget-id");

            if (entityId) {
                $.ajax({
                    url: Routing.generate("designer_widget_favorite", {id: entityId}),
                    data: {"favorite":!isFavorite},
                    dataType: "json",
                    method: "post",
                    success: function() {
                        _this.toggleClass("fa-star fa-star-o");
                        var parent = _this.parents('[data-widget-id]');

                        if (fromSearch) {
                            if (!isFavorite) {
                                parent.appendTo('.list ul');
                            }
                        }

                        if (isFavorite) {
                            parent.remove();
                        }
                    }
                });
            }
        });
    };

    return {
        init: function(element, fromSearch){
            bindFavorites(element, fromSearch);
        }
    }
}());
