var CsCustomHtml = function(){

    var CsCustomHtml = function(){

        this.customHtml = this.createCustomHtml();
        this.modal = {
            id: 'cs-custom-html',
            html: '',
            options: {},
            searchInput: {},
            resultsContainer: {}
        };

        this.callBack = {};
    };

    CsCustomHtml.prototype.createCustomHtml = function() {
        return  {
            id: this.customHtml ? this.customHtml.id : '',
            title: '',
            image: '',
            value: '<h1>Test</h1>'
        };
    };

    CsCustomHtml.prototype.exec = function(customHtml, callBack) {
        var _this = this;

        this.callBack = callBack;

        this.customHtml = customHtml;

        this.signals.onModalContentLoaded.add(function() {
            _this.bindFunctions();
            $('body').addClass('modal-open-noscroll');
        });

        this.signals.onDestroyModal.add(function() {
            _this.reset();
            $('body').removeClass('modal-open-noscroll');
        });

        this.showModal();
    };

    CsCustomHtml.prototype.createModal = function(callBack) {

        var _this = this;

        this.modal.html = $('<div></div>')
            .attr({
                "id":this.modal.id,
                "class": 'modal fade bs-modal-lg',
                "tabindex": "-1",
                "role": "dialog",
                "aria-labelledby": "myModalLabel1",
                "aria-hidden": "true"
            })
            .load(Routing.generate('cs_core_custom_html_modal'), function(){
                _this.signals.onModalContentLoaded.dispatch();
            })
            .modal({
                show: false
            });

        $('body').append(this.modal.html);

        this.modal.html.on('hidden.bs.modal', function () {
            _this.destroyModal();
        });

        this.signals.onModalCreated.dispatch();

        callBack.call(this,this);
    };

    CsCustomHtml.prototype.destroyModal = function() {
        this.signals.onDestroyModal.dispatch();
    };

    CsCustomHtml.prototype.showModal = function() {
        this.createModal(function(){
            this.modal.html.modal().show();
        });
    };

    CsCustomHtml.prototype.hideModal = function() {
        this.modal.html.modal('hide');
    };

    CsCustomHtml.prototype.bindFunctions = function() {
        var _this = this;

        Metronic.init();

        this.modal.html.on('click', '#custom-html-content label', function(){
            _this.modal.html.find('#custom-html-submit').prop('disabled', false);
        });

        this.modal.html.on('click', '#custom-html-submit', function(){
            var selectedCustomHtml = $('input[name="custom_html"]:checked');
            _this.customHtml.value = selectedCustomHtml.val();
            _this.customHtml.id = selectedCustomHtml.attr('id');
            _this.sendCallBack();
        });
    };

    CsCustomHtml.prototype.reset = function() {
        var _this = this;

        $("#" + this.modal.id).remove();

        $.each(_this.signals, function(k,v){
            v.removeAll();
        });
    };

    CsCustomHtml.prototype.sendCallBack = function() {
        if ( typeof this.callBack === 'function') {
            this.hideModal();
            this.callBack.call(this,this);
        }
    };

    CsCustomHtml.prototype.signals = {
        onModalCreated: new signals.Signal(),
        onDestroyModal: new signals.Signal(),
        onModalContentLoaded: new signals.Signal(),
    };

    return {
        init: function() {
            return new CsCustomHtml();
        }
    };
}();
