<?php

namespace Comitium5\DesignerBundle\ValueObjects;

/**
 * Class SearchOrderObject
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\ValueObjects
 */
class SearchOrderObject
{
    const ORDER_DESCENDANT = "desc";
    const ORDER_ASCENDANT  = "asc";

    /**
     * @var string
     */
    private $field;

    /**
     * @var string
     */
    private $sort;

    /**
     * SearchOrderObject constructor.
     *
     * @param string $field
     * @param string $sort
     */
    public function __construct(string $field = "id", string $sort = self::ORDER_DESCENDANT)
    {
        $this->field = $field;
        $this->sort = $sort;
    }

    /**
     * @return string
     */
    public function getField(): string
    {
        return $this->field;
    }

    /**
     * @return string
     */
    public function getSort(): string
    {
        return $this->sort;
    }
}
