<?php

namespace Comitium5\DesignerBundle\Validator\Widget;

use Comitium5\DesignerBundle\Model\Interfaces\IdentifiableInterface;
use Comitium5\DesignerBundle\Validator\EntityValidatorConstraintAbstract;
use Comitium5\DesignerBundle\Validator\EntityValidatorConstraintInterface;

/**
 * Class WidgetNameIsValid
 *
 * Joan Pont <joan.pont@bab-soft.com>
 * @package Comitium5\DesignerBundle\Validator\Widget
 */
class WidgetNameIsValid extends EntityValidatorConstraintAbstract implements EntityValidatorConstraintInterface
{
    /**
     * PageHasRelatedTemplateConstraint constructor.
     */
    public function __construct()
    {
        $this->message = "common.errors.widget.widget_name_is_invalid";
    }

    /**
     * @param IdentifiableInterface $widget
     *
     * @return bool
     */
    public function check(IdentifiableInterface $widget): bool
    {
        return is_int(strpos($widget->getName(), " "));
    }
}