<?php

namespace Comitium5\DesignerBundle\Validator;

use Comitium5\DesignerBundle\Model\Interfaces\IdentifiableInterface;

/**
 * Class EntityValidator
 *
 * Joan Pont <joan.pont@bab-soft.com>
 * @package Comitium5\DesignerBundle\Validator
 */
class EntityValidator implements EntityValidatorInterface
{
    /**
     * @param IdentifiableInterface|null $entity
     * @param EntityValidatorConstraintInterface[] $constraints
     *
     * @return EntityValidatedResult|mixed
     */
    public function validate(IdentifiableInterface $entity = null, array $constraints = [])
    {
        $entityValidated = $this->createResultObj();

        foreach ($constraints as $constraint) {
            if ($constraint->check($entity) == false) {
                $entityValidated->add($constraint);
            }
        }

        return $entityValidated;
    }

    /*
     *
     */
    protected function createResultObj() {
        return new EntityValidatedResult();
    }
}
