<?php

namespace Comitium5\DesignerBundle\UseCase\Search;

use Comitium5\DesignerBundle\Form\DataTransformer\MultipleSubSiteSuggestDataTransformer;
use Comitium5\DesignerBundle\Model\Interfaces\SearchRepositoryInterface;
use Comitium5\DesignerBundle\ValueObjects\SearchQueryObject;
use Comitium5\DesignerBundle\ValueObjects\SearchResultObject;

/**
 * Class MultiSubSiteSuggestSearchUseCase
 *
 * @author David Carrascosa <david@bab-soft.com>
 * @package Comitium5\DesignerBundle\UseCase\Search
 */
class MultiSubSiteSuggestSearchUseCase extends SuggestSearchUseCase
{
    /**
     * MultiSubSiteSuggestSearchUseCase constructor.
     *
     * @param SearchRepositoryInterface $searchRepository
     * @param SearchQueryObject $searchQueryObject
     * @param string $labelProperties
     * @param string $property
     */
    public function __construct(
        SearchRepositoryInterface $searchRepository,
        SearchQueryObject $searchQueryObject,
        string $labelProperties,
        string $property
    ) {
        parent::__construct(
            $searchRepository,
            $searchQueryObject,
            $labelProperties,
            $property
        );
    }

    /**
     * @param SearchResultObject $results
     *
     * @return array|array[]
     * @throws \Exception
     */
    protected function serialize(SearchResultObject $results): array
    {
        $data = [
            'results' => []
        ];

        $included = [];

        foreach ($results->getResults() as $result) {
            if (!in_array($result->getId(), $included)) {
                $data['results'][] = [
                    'description' => MultipleSubSiteSuggestDataTransformer::resolveDataDescription($result),
                    'enabled'     => $result->isSearchable(),
                    'future'      => MultipleSubSiteSuggestDataTransformer::resolveFuture($result),
                    'date'        => MultipleSubSiteSuggestDataTransformer::resolveEntityDate($result),
                    'id'          => MultipleSubSiteSuggestDataTransformer::buildSubSiteIdString($result),
                    'text'        => $this->buildText($result),
                ];
            }

            $included[] = $result->getId();
        }

        return $data;
    }
}