<?php

namespace Comitium5\DesignerBundle\UseCase\Page;

use Comitium5\DesignerBundle\Model\Interfaces\Page\PageRepositoryInterface;
use Comitium5\DesignerBundle\Repository\Template\TemplateRepository;
use Symfony\Component\HttpFoundation\JsonResponse;

/**
 * Class AssignTemplateToPageController
 *
 * Joan Pont <joan.pont@bab-soft.com>
 * @package Comitium5\DesignerBundle\Controller\Page
 */
class AssignTemplateToPageUseCase
{

    /**
     * @var PageRepositoryInterface
     */
    private $pageRepository;

    /**
     * @var TemplateRepository
     */
    private $templateRepository;

    /**
     * AssignTemplateToPageController constructor.
     *
     * @param PageRepositoryInterface $pageRepository
     * @param TemplateRepository $templateRepository
     */
    public function __construct(PageRepositoryInterface $pageRepository, TemplateRepository $templateRepository)
    {
        $this->pageRepository = $pageRepository;
        $this->templateRepository = $templateRepository;
    }

    /**
     * @param $id
     * @param $templateId
     *
     * @return JsonResponse
     */
    public function __invoke(int $id, int $templateId) : JsonResponse
    {
        $page = $this->pageRepository->find($id);
        $template = $this->templateRepository->find($templateId);

        $page->setTemplate($template);

        $this->pageRepository->savePage($page);

        return new JsonResponse([
            "status" => 200,
            "message" => "Template assigned"
        ]);
    }
}