<?php

namespace Comitium5\DesignerBundle\UseCase\Asset;

use Comitium5\ApiClientBundle\Client\Services\AssetApiService;
use Comitium5\ApiClientBundle\ValueObject\IdentifiedValue;
use Comitium5\ApiClientBundle\ValueObject\ParametersValue;

/**
 * Class UpdateAssetUseCase
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\UseCase\Asset
 */
class UpdateAssetUseCase
{
    /**
     * @var AssetApiService
     */
    private $assetApiService;

    /**
     * UpdateAssetUseCase constructor.
     *
     * @param AssetApiService $assetApiService
     */
    public function __construct(AssetApiService $assetApiService)
    {
        $this->assetApiService = $assetApiService;
    }

    /**
     * @param IdentifiedValue $assetId
     * @param ParametersValue $parameters
     *
     * @return array
     * @throws \Exception
     */
    public function __invoke(IdentifiedValue $assetId, ParametersValue $parameters): array
    {
        return $this
            ->assetApiService
            ->put($assetId, $parameters);
    }
}
