<?php

namespace Comitium5\DesignerBundle\Tests\UseCase\Page;


use Comitium5\DesignerBundle\Entity\Page;
use Comitium5\DesignerBundle\Factory\Page\DesignerPageFactory;
use Comitium5\DesignerBundle\Model\Interfaces\Page\DesignerPageInterface;
use Comitium5\DesignerBundle\Model\Interfaces\Page\PageManagerInterface;
use Comitium5\DesignerBundle\Model\Interfaces\Page\PageRepositoryInterface;
use Comitium5\DesignerBundle\Tests\AbstractTestCase;
use Comitium5\DesignerBundle\UseCase\Page\CreatePageUseCase;

/**
 * Class CreatePageUseCaseTest
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Tests\PageContext\Application\UseCase
 */
class CreatePageUseCaseTest extends AbstractTestCase
{
    /**
     *
     */
    public function testCreateWithExistingPage()
    {
        $pageId = 1;

        $usePageCase = new CreatePageUseCase(
            $this->pageRepositoryWithPage($pageId),
            new DesignerPageFactory()
        );

        $page = $usePageCase($pageId);

        $this->assertInstanceOf(DesignerPageInterface::class, $page);
        $this->assertEquals($pageId, $page->getOriginId());
    }

    /**
     *
     */
    public function testCreateWithoutExistingPage()
    {
        $pageId = 2;

        $usePageCase = new CreatePageUseCase(
            $this->pageRepositoryWithoutPage($pageId),
            new DesignerPageFactory()
        );

        $page = $usePageCase($pageId);

        $this->assertInstanceOf(DesignerPageInterface::class, $page);
        $this->assertEquals($pageId, $page->getOriginId());
    }

    /**
     * @param int $pageId
     *
     * @return PageRepositoryInterface|\PHPUnit\Framework\MockObject\MockObject
     */
    private function pageRepositoryWithPage(int $pageId)
    {
        $mock = $this->createMock(PageRepositoryInterface::class);

        $page = new Page();

        $page->setOriginId($pageId);

        $mock
            ->method("getPageFromOrigin")
            ->willReturn($page);

        return $mock;
    }

    /**
     * @param int $pageId
     *
     * @return PageRepositoryInterface|\PHPUnit\Framework\MockObject\MockObject
     */
    private function pageRepositoryWithoutPage(int $pageId)
    {
        $mock = $this->createMock(PageRepositoryInterface::class);

        $page = new Page();

        $page->setOriginId($pageId);

        $mock
            ->method("getPageFromOrigin")
            ->willReturn(null);

        $mock
            ->method("savePage")
            ->willReturn($page);

        return $mock;
    }
}
