<?php

namespace Comitium5\DesignerBundle\Service\Pagination;

use Comitium5\DesignerBundle\Model\Interfaces\Pagination\PaginationInterface;
use Knp\Component\Pager\Pagination\AbstractPagination;

/**
 * Class KnpPagination
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Service\Pagination
 */
class KnpPagination implements PaginationInterface
{
    /**
     * @var AbstractPagination
     */
    protected $pagination;

    /**
     * KnpPagination constructor.
     *
     * @param AbstractPagination $pagination
     */
    public function __construct(AbstractPagination $pagination)
    {
        $this->pagination = $pagination;
    }

    /**
     * @return AbstractPagination
     */
    public function getPagination()
    {
        return $this->pagination;
    }

    /**
     * @param array $items
     *
     * @return $this|mixed
     */
    public function setItems(array $items)
    {
        $this
            ->pagination
            ->setItems($items);

        return $this;
    }

    /**
     * @return array|mixed
     */
    public function getItems()
    {
        return $this
            ->pagination
            ->getItems();
    }

    /**
     * @param int $total
     *
     * @return $this|mixed
     */
    public function setTotalItemCount(int $total)
    {
        $this
            ->pagination
            ->setTotalItemCount($total);

        return $this;
    }
}
