var StaticContent = function(){

    var init = function () {

        $("[data-reflection]").each(function(){

            $(this).on("change", function(){

                var reflection = $(this).data("reflection");
                var value = $(this).val();
                $(reflection).val(value);
           });
        });

        $('.add-yml-row').each(function(){

            var wrapper = $(this).parent().prev();

            wrapper.data('count', wrapper.find('[data-type="yml-content"]').length);

            $(this).on('click', function(e) {
                e.preventDefault();

                // grab the prototype template
                var newWidget = wrapper.attr('data-prototype');

                var count = wrapper.data('count');

                newWidget = newWidget.replace(/__name__/g, count);
                count++;

                wrapper.data('count', count);

                wrapper.append(newWidget);

            });
        });

        $('.remove-yml-row').each(function(){
            var wrapper = $(this).closest('[data-type="yml-content"]');
            $(this).on('click', function(){
                wrapper.fadeOut(400, function(){
                    $(this).remove();
                });
            });


        });
    };

    return {
        init: function() {
            init();
        }
    };
}();