var AutoFieldCompletion = (function() {

    var defaultOptions = {
        originElement: null,
        targetElement: null,
        beforeCopy: null,
        multipleElementSeparator: " "
    };

    var copyData = function(options) {
        options = $.extend(defaultOptions, options);

        if (!options.originElement && !options.targetElement) {
            throw "Origin and target elements must be defined";
        }

        var data = "";

        if (options.originElement instanceof Array) {
            for (var i = 0; i < options.originElement.length; i++) {
                data = data + options.originElement[i] + options.multipleElementSeparator;
            }
        } else {
            data = ComitiumUtils.getElementData(options.originElement);
        }

        if (typeof options.beforeCopy == "function") {
            data = options.beforeCopy.call(this, data);
        }

        ComitiumUtils.setElementData(options.targetElement, data);
    };

    return {
        copy: function(options) {
            copyData(options);
        }
    };
})();
