var menuInteraction = function () {

    var subsitesDropdownBtn = $('[data-role="subsites-dropdown-btn"]'),
        subsitesDropdown = $('[data-role="subsites-dropdown"]'),
        navBtn = $('[data-role="c-navigation-btn"]'),
        nav = $('[data-role="c-navigation"]'),
        searchBtn = $('[data-role="c-search-btn"]'),
        search = $('.cs-module-search'),
        advancedSearch = $('.cs-module-search-advanced'),
        navMenu = $('[data-role="c-nav"]'),
        navItemDashboard = $('[data-section="dashboard"]'),
        navItemCms = $('[data-section="cms"]'),
        navItemCrm = $('[data-section="crm"]'),
        navItemAdmin = $('[data-section="administration"]'),
        mainContainer = $('[data-role="c-main-container"]'),
        myMenuBtn = $('[data-role="my-menu-btn"]'),
        myMenuBtnConfig = $('[data-role="my-menu-btn-config"]'),
        myMenu = $('[data-role="my-menu"]'),
        addBtn = $('[data-role="add-btn"]'),
        fullNavBtn = $('[data-role="full-nav-btn"]'),
        myMenuActive = 0,
        myMenuItems = []
    ;

    function setSaveChangeConfigButtonText() {
        myMenuBtnConfig.text(Translator.trans("common.menu.favorites.save_changes"));
    }

    function showItemSubsites(){
        subsitesDropdown.slideDown(300);
        subsitesDropdownBtn.addClass('active');
    }
    function hideItemSubsites(){
        subsitesDropdown.slideUp(300);
        subsitesDropdownBtn.removeClass('active');
    }
    function showItemCms(){
        navItemCms.children("ul").slideDown();
        navItemCms.addClass("open");
    }
    function hideItemCms(){
        navItemCms.children("ul").slideUp();
        navItemCms.removeClass("open");
    }
    function showItemCrm(){
        navItemCrm.children("ul").slideDown();
        navItemCrm.addClass("open");
    }
    function hideItemCrm(){
        navItemCrm.children("ul").slideUp();
        navItemCrm.removeClass("open");
    }
    function showItemAdmin(){
        navItemAdmin.children("ul").slideDown();
        navItemAdmin.addClass("open");
    }
    function hideItemAdmin(){
        navItemAdmin.children("ul").slideUp();
        navItemAdmin.removeClass("open");
    }
    function showItemFullNav(){
        fullNavBtn.slideDown();
    }
    function hideItemFullNav(){
        fullNavBtn.slideUp();
    }
    function showFullNavigation(){
        navItemDashboard.slideDown();
        navItemCms.slideDown();
        navItemCrm.slideDown();
        navItemAdmin.slideDown();
    }
    function hideFullNavigation(){
        navItemDashboard.slideUp();
        navItemCms.slideUp();
        navItemCrm.slideUp();
        navItemAdmin.slideUp();
        hideItemCms();
        hideItemCrm();
        hideItemAdmin();
    }

    navBtn.click(function(){
        if($(window).width() > 768) {
            nav.toggleClass('closed');
            navBtn.toggleClass('active');
            mainContainer.toggleClass('navigation-closed');
            $('body').toggleClass('navigation-closed');
        } else {
            nav.toggleClass('opened');
            navBtn.toggleClass('active');
        }
    });

    searchBtn.click(function(){
        searchBtn.toggleClass('active');
        if(search.is(':hidden')) {
            search.slideDown();
        } else {
            search.slideUp();
            advancedSearch.slideUp();
            $(".cs-module-search .input-group .input-group-addon").removeClass("active");
        }
    });

    addBtn.click(function(e){

        var $this         = $(this);
        var clonedElement = $(this).parent("li").clone().css('display', 'none');
        var section = clonedElement.data("section");

        myMenu.append(clonedElement);
        addFavorite(section);

        if (typeof e.isTrigger === 'undefined') {
          setSaveChangeConfigButtonText();
        }

        clonedElement.children("span").removeClass("add").addClass("remove").attr({
            "data-role": "delete-btn",
            "title": Translator.trans("common.menu.favorites.delete")
        }).click(function(event){

            event.preventDefault();
            event.stopImmediatePropagation();

            $(this).parent("li").slideUp(function() {
                $(this).remove();
                $this.removeClass("added");
                removeFavorite(section);
                setSaveChangeConfigButtonText();

            });
        });

        clonedElement.slideDown();

        $(this).addClass("added");
    });

    subsitesDropdownBtn.click(function(){
        subsitesDropdownBtn.toggleClass('active');
        if(subsitesDropdown.is(':hidden')) {
            showItemSubsites();
            hideItemCrm();
            hideItemAdmin();
            hideItemCms();
            nav.removeClass("full-opened");
            myMenu.removeClass('active');
            myMenuBtnConfig.text(Translator.trans("common.menu.favorites.config"));
        } else {
            hideItemSubsites();
        }
    });

    myMenuBtnConfig.click(function(){
        if(navItemCms.children("ul").is(':hidden') || navItemCrm.children("ul").is(':hidden') || navItemAdmin.children("ul").is(':hidden')) {
            toogleActiveItems("disabled");
            myMenuActive = 1;
            nav.addClass("full-opened");
            myMenu.addClass('active');
            myMenuBtnConfig.addClass('active');
            myMenuBtnConfig.text(Translator.trans("common.menu.favorites.close"));
            hideItemFullNav();
            showFullNavigation();
            showItemCms();
            showItemCrm();
            showItemAdmin();

        } else {
            toogleActiveItems("enabled");
            nav.removeClass("full-opened");
            myMenu.removeClass('active');
            myMenuBtnConfig.removeClass('active');
            myMenuBtnConfig.text(Translator.trans("common.menu.favorites.config"));
            if (myMenuActive !== 1) {
                showItemFullNav();
                hideFullNavigation();
            }
            fullNavBtn.removeClass('active');
            fullNavBtn.text(Translator.trans("common.menu.fullNavigation.show"));
            hideItemCms();
            hideItemCrm();
            hideItemAdmin();
            myMenuActive = 0;
            saveMyMenu();
        }
    });

    fullNavBtn.click(function(){
        if(navItemCms.is(':hidden') || navItemCrm.is(':hidden') || navItemAdmin.is(':hidden')) {
            fullNavBtn.addClass('active');
            showFullNavigation();
            fullNavBtn.text(Translator.trans("common.menu.fullNavigation.hide"));
        } else {
            fullNavBtn.removeClass('active');
            hideFullNavigation();
            fullNavBtn.text(Translator.trans("common.menu.fullNavigation.show"));
        }
    });

    navItemCms.click(function(e, menuActive){

        if (menuActive && menuActive.menuActive === true) {
            return;
        }

        if (myMenuActive) {
            e.preventDefault();
        }


        if(navItemCms.children("ul").is(':hidden')) {
            showItemCms();
            hideItemCrm();
            hideItemAdmin();
            hideItemSubsites();
        } else {
            if(myMenuActive !== 1 && !isLink(e)) {
                hideItemCms();
            }
        }
    });

    navItemCrm.click(function(e, menuActive){
        if (menuActive && menuActive.menuActive === true) {
            return;
        }

        if(navItemCrm.children("ul").is(':hidden')) {
            showItemCrm();
            hideItemCms();
            hideItemAdmin();
            hideItemSubsites();
        } else {
            if(myMenuActive !== 1 && !isLink(e)) {
                hideItemCrm();
            }
        }
    });

    navItemAdmin.click(function(e, menuActive){
        if (menuActive && menuActive.menuActive === true) {
            return;
        }

        if(navItemAdmin.children("ul").is(':hidden')) {
            showItemAdmin();
            hideItemCrm();
            hideItemCms();
            hideItemSubsites();
        } else {
            if(myMenuActive !== 1 && !isLink(e)) {
                hideItemAdmin();
            }
        }
    });

    isLink = function(e) {
        return $(e.target).attr("href") !== "#";
    };

    addFavorite = function(section) {
        myMenuItems.push(section)
    };

    removeFavorite = function(section) {
        myMenuItems = myMenuItems.filter(function (item) {
            return item !== section;
        })
    };

    saveMyMenu = function () {
        localStorage.setItem("my-menu", myMenuItems.join(","));
        if(myMenuItems == '') {
            hideItemFullNav();
            showFullNavigation();
        } else {
            showItemFullNav();
            hideFullNavigation();
        }
    };

    toogleActiveItems = function(action) {
        if (action === "enabled") {
            $('[data-section].no-active').toggleClass("no-active active ");
        } else {
            $('[data-section].active').toggleClass("no-active active ");
        }
    };

    return {

        //main function to initiate the theme
        init: function () {
            myMenuCookie = localStorage.getItem("my-menu");

            if (myMenuCookie) {
                myMenuCookie.split(",").map(function(section) {
                    $('[data-section="'+section+'"] span').trigger("click", { menuActive: true })
                });
                hideItemCms();
                hideItemCrm();
                hideItemAdmin();
                showItemFullNav();
                hideFullNavigation();
            } else {
                hideItemFullNav();
                showFullNavigation();
            }

            /*
            showItemSubsites();
            hideItemSubsites();
            showItemCms();
            hideItemCms();
            showItemCrm();
            hideItemCrm();
            showItemAdmin();
            hideItemAdmin();*/

        },
    };

}();
/*
mainContainer.scroll(function() {

    if ((mainContainer.scrollTop() > 50 || mainContainer.height() > $(".page-content-wrapper").height()) && !mainContainer.hasClass("show")) {
        $(".form-actions").addClass("show");
    } else {
        $(".form-actions").removeClass("show");
    }

});*/
