function ComitiumReleases() {
    this.container = $("#comitium_new_release_container");
    this.showContainerUrl = Routing.generate("cs_core_releases_infobox_html");
    this.updateUserVersionUrl = Routing.generate("cs_core_releases_update");
    this.elementInfobox = null;
    this.btnDisplayReleases = null;
    this.btnClose = null;
    this.modal = null;

    this.init();
}

ComitiumReleases.prototype.init = function () {
    var _this = this;

    var promise = _this.fetchInfoboxContent();

    $.when(promise).done(
        function () {
            _this.bindInfoboxElements();
            _this.bindInfoboxEvents();
            _this.bindModalEvents();
            _this.showInfobox();
        }
    );
};

ComitiumReleases.prototype.fetchInfoboxContent = function () {
    var _this = this;

    return $.ajax({
        url: _this.showContainerUrl,
        type: "GET",
        success: function(data) {
            _this.container.html(data);
        }
    });
};

ComitiumReleases.prototype.bindInfoboxElements = function () {
    var _this = this;
    _this.elementInfobox = $("#comitium_new_release");
    _this.btnDisplayReleases = $("[data-comitium-open-release-btn]");
    _this.btnClose = $("[data-comitium-close-infobox-btn]");
    _this.modal = $(".modal-releases");
};

ComitiumReleases.prototype.bindInfoboxEvents = function () {
    var _this = this;
    _this.closeInfoboxAction();

    if (_this.btnDisplayReleases.length > 0) {
        _this.showModalAction();
    }
};

ComitiumReleases.prototype.bindModalEvents = function () {
    var _this = this;
    if (_this.modal.length > 0) {
        _this.closeModalAction();
    }
};

ComitiumReleases.prototype.showModal = function () {
    var _this = this;
    _this.modal.addClass("show");
};

ComitiumReleases.prototype.closeModal = function () {
    var _this = this;
    _this.modal.remove();
};

ComitiumReleases.prototype.showInfobox = function () {
    var _this = this;
    _this.elementInfobox.fadeIn();
};

ComitiumReleases.prototype.hideInfobox = function () {
    var _this = this;
    _this.elementInfobox.fadeOut();
};

ComitiumReleases.prototype.closeInfoboxAction = function () {
    var _this = this;
    _this.btnClose.on("click", function () {
        _this.hideInfobox();
        _this.updateUserVersionAction();
    });
};

ComitiumReleases.prototype.showModalAction = function () {
    var _this = this;
    _this.btnDisplayReleases.on("click", function () {
        _this.showModal();
    });
};

ComitiumReleases.prototype.closeModalAction = function () {
    var _this = this;

    var close = function () {
        _this.hideInfobox();
        _this.closeModal();
        _this.updateUserVersionAction();
    };

    _this.modal.find('[data-dismiss="modal"]').on("click", close);
    _this.modal.find('[data-btn-type="accept"]').on("click", close);
};

ComitiumReleases.prototype.updateUserVersionAction = function () {
    var _this = this;

    return $.ajax({
        url: _this.updateUserVersionUrl,
        type: "POST",
        dataType: "json"
    });
};