var GoogleAnalyticsEmbedAPI = function() {
    var siteId;

    var chartTypes = {
        LINE : "LINE",
        COLUMN : "COLUMN",
        BAR : "BAR",
        TABLE : "TABLE",
        GEO : "GEO",
        PIE: "PIE"
    };

    var metricTypes = {
        PERCENT: "PERCENT",
        TIME: "TIME",
        INTEGER: "INTEGER",
        FLOAT: "FLOAT"
    };

    var initStatistics = new signals.Signal();

    var init = function(accessToken){

        gapi.analytics.ready(function() {

            gapi.analytics.auth.authorize({
                serverAuth: {
                    access_token: accessToken
                }
            });

            gapi.client.load('analytics', 'v3').then(function() {
                gapi.client.analytics.management.accounts.list().then(handleAccounts);
            });
        });
    };

    var handleAccounts = function(response) {
        // Handles the response from the accounts list method.
        if (response.result.items && response.result.items.length) {
            // Get the first Google Analytics account.
            var firstAccountId = response.result.items[0].id;

            // Query for properties.
            queryProperties(firstAccountId);
        }
    };


    var queryProperties = function(accountId) {
        // Get a list of all the properties for the account.
        gapi.client.analytics.management.webproperties.list(
            {'accountId': accountId})
            .then(handleProperties)
            .then(null, function(err) {});
    };


    var handleProperties = function(response) {
        // Handles the response from the webproperties list method.
        if (response.result.items && response.result.items.length) {

            // Get the first Google Analytics account
            var firstAccountId = response.result.items[0].accountId;

            // Get the first property ID
            var firstPropertyId = response.result.items[0].id;

            // Query for Views (Profiles).
            queryProfiles(firstAccountId, firstPropertyId);
        }
    };


    var queryProfiles = function(accountId, propertyId) {
        // Get a list of all Views (Profiles) for the first property
        // of the first Account.
        gapi.client.analytics.management.profiles.list({
            'accountId': accountId,
            'webPropertyId': propertyId
        })
            .then(handleProfiles);
    };


    var handleProfiles = function(response) {
        // Handles the response from the profiles list method.
        if (response.result.items && response.result.items.length) {
            // Get the first View (Profile) ID.
            siteId = "ga:" + response.result.items[0].id;

            initStatistics.dispatch(siteId);
        }
    };

    return {
        init: function(accessToken) {
            if(accessToken){
                init(accessToken);
            }else{
                alert("You have to pass valid access token");
            }
        },
        initStatistics: function(action,method,enviroment){
            initStatistics[action](method,enviroment)
        },
        getChartType: function(chartType){
            if(chartType in chartTypes){
                return chartTypes[chartType];
            }
        },
        getMetricType: function(metricType){
            if(metricType in metricTypes){
                return metricTypes[metricType];
            }
        },
        getSiteId: function(){
            return siteId;
        }
    };
}();