CKEDITOR.plugins.add('csaudio', {
    init: function(editor) {
        editor.csAudio = CsAsset.init("sound");

        editor
            .csAudio
            .setAbsoluteUrlFromCKEditor(editor);

        var command = new CKEDITOR.command( editor, {
            exec: function( editor ) {

                _initEvents();

                var selectedElement = editor.getSelection().getSelectedElement();
                var asset = _build(selectedElement);

                editor.csAudio.exec(asset, function(element){
                    _createElement(element);
                });
            }
        } );

        var _initEvents = function() {

            editor.focusManager.lock();

            editor.csAudio.signals.onDestroyModal.add(function(){
                editor.focusManager.unlock();
                editor.csAudio.asset.id = "";
            });
        };

        var _createElement = function(element){
            var parent = getParent(editor.getSelection().getSelectedElement());

            if (parent) {
                parent.remove();
            }

            if (element.asset.src) {
                var e = editor.document.createElement( 'audio');
                e.setAttribute('title', element.asset.title);
                e.setAttribute('src', element.asset.src);
                e.setAttribute('controls', "");

                if (element.asset.html) {
                    var html    = element.asset.html.replace("@asset@", e.getOuterHtml());
                    var wrapper = editor.document.createElement(createElementFromHTML(html));

                    editor.insertElement(wrapper);
                } else {
                    editor.insertElement(e);
                }
            }
        };

        var _build = function(element) {
            var asset  = editor.csAudio.createAsset();

            if (!element || !element.is("audio")) {
                return asset;
            }

            var parent = getParent(element);

            if (parent) {
                asset.html = parent.getOuterHtml().replace(/<img[^>]*>/, "@asset@");
            }

            if (element.getAttribute('src')) {
                asset.src = element.getAttribute('src');
            }
            if (element.getAttribute('title')) {
                asset.title = element.getAttribute('title');
            }

            return asset;
        };

        function createElementFromHTML(htmlString) {
            var div = document.createElement('div');

            div.innerHTML = htmlString.trim();

            return div.firstChild;
        }

        function getParent(element) {

            if (!element) {
                return null;
            }

            var parents = element.getParents(true);
            var parent = null;

            parents.forEach(function(p){
                if (p.hasAttribute("data-ck-asset-wrapper")) {
                    parent = p;
                    return false;
                }
            });

            return parent;
        }

        editor.addCommand( 'csaudio', command);

        editor.ui.addButton( 'CsAudio', {
            label: Translator.trans('cs_core.cs_audio.label'),
            command: 'csaudio',
            toolbar: 'audio',
            icon: this.path + 'icons/csaudio.png'
        });
    }
});
