/**
 * @license Copyright (c) 2003-2019, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see https://ckeditor.com/legal/ckeditor-oss-license
 */

CKEDITOR.editorConfig = function( config ) {
    // Define changes to default configuration here.
    // For complete reference see:
    // http://docs.ckeditor.com/#!/api/CKEDITOR.config

    // The toolbar groups arrangement, optimized for two toolbar rows.
    config.toolbarGroups = [
        { name: 'clipboard',   groups: [ 'clipboard', 'undo' ] },
        { name: 'editing',     groups: [ 'find', 'selection', 'spellchecker' ] },
        { name: 'links' },
        { name: 'insert' },
        { name: 'forms' },
        { name: 'tools' },
        { name: 'document',	   groups: [ 'mode', 'document', 'doctools' ] },
        { name: 'others' },
        '/',
        { name: 'basicstyles', groups: [ 'basicstyles', 'cleanup' ] },
        { name: 'paragraph',   groups: [ 'list', 'indent', 'blocks', 'align', 'bidi' ] },
        { name: 'styles' },
        { name: 'colors' },
        { name: 'about' }
    ];

    // Remove some buttons provided by the standard plugins, which are
    // not needed in the Standard(s) toolbar.
    //config.removeButtons = 'Underline,Subscript,Superscript';

    // Set the most common block elements.
    //config.format_tags = 'p;h1;h2;h3;pre';

    // Simplify the dialog windows.
    config.removeDialogTabs = 'image:advanced;link:advanced';

    config.allowedContent = true;
    config.extraAllowedContent = ["a[!href,title,rel,data-external,target,data-mirror,data-cut];", "div[*]", "iframe[*]", "video[*]", "script[*]"];
    config.extraPlugins = 'jqueryspellchecker';
};

CKEDITOR.dtd.$removeEmpty.span = 1;

// Fix image width/height in dialgo
CKEDITOR.on('instanceReady', function (ev) {
// Ends self closing tags the HTML4 way, like <br>.
    ev.editor.dataProcessor.htmlFilter.addRules(
        {
            elements: {
                $: function (element) {
                    // Output dimensions of images as width and height
                    if (element.name === 'img') {
                        var style = element.attributes.style;

                        if (style) {
                            // Get the width from the style.
                            var match = /(?:^|\s)width\s*:\s*(\d+)px/i.exec(style),
                                width = match && match[1];

                            // Get the height from the style.
                            match = /(?:^|\s)height\s*:\s*(\d+)px/i.exec(style);
                            var height = match && match[1];

                            if (width) {
                                element.attributes.style = element.attributes.style.replace(/(?:^|\s)width\s*:\s*(\d+)px;?/i, '');
                                element.attributes.width = width;
                                element.attributes.width = "50%";
                            }

                            if (height) {
                                element.attributes.style = element.attributes.style.replace(/(?:^|\s)height\s*:\s*(\d+)px;?/i, '');
                                element.attributes.height = height;
                            }
                        }
                    }

                    if (!element.attributes.style) {
                        delete element.attributes.style;
                    }

                    if (element.name === 'span') {
                        if (typeof element.attributes.class === "string") {
                            if (element.attributes.class === "spellchecker-word-highlight") {
                                delete element.name;
                            }
                        }

                        if (typeof element.attributes.style === "string") {
                            if (element.attributes.style.match(/^color:(red|green|yellow)/g) !== null) {
                                delete element.name;
                            }
                        }
                    }

                    if (element.name === 'font') {
                        delete element.name;
                    }

                    if (element.name === 'contenteditable') {
                        delete element.name;
                    }

                    return element;
                }
            }
        });
});
