Comitium Designer Bundle
========================

This bundle, is intended to contain all comitium designer logic to
abstract it from comitium backend.

Installation
------------
```
php composer.phar require comitium5/designer-bundle "^7.0"

npm install uglify-js@2.6.1
npm install uglifycss@0.0.20
npm install node-sass@^4.13
```

Development
-----------
To make it easier for the bundle maintaining, we will link our local
repository as a dependency. This will help us, for example, for the migration generation.

1 - Clone repository to the parent folder where the main project is.

2 - Add this path to composer.json

``
"repositories": [
    {
        "type": "path",
        "url": "../designer-bundle"
    },
]
``

3 - Add the following environment variable to .env file with the local bundle path as value.
``
DESIGNER_BUNDLE_PATH=~/Projects/docker/bundles/server/designer-bundle
``

4 - Install Designer Bundle to symlink it to our main project.

``
php composer.phar require comitium5/designer-bundle "^7.0"
``

Migrations
----------
All doctrine migration commands must be executed with the
following configuration option: 

``
php app/console d:m:g --configuration=vendor/comitium5/designer-bundle/Resources/config/doctrine_migrations.yml
``

This, will allow us to generate migrations on a separate table in our database, 
and later on, execute them easily without no conflicts with backend migrations.

RUN CONSUMERS
-------------
This project contains some commands as RabbitMQ consumers. Edit connection params with your needs.

```
php app/console comitium:designer:consumer:page:created --host rabbit --username rabbitmq --password rabbitmq --port 5672 --exchange comitium.topic --routing-key comitium.site-dev.subsite-1.cms.1.event.page.created --queue-name clientA.create_page_on_comitium_created_page -vvv

php app/console comitium:designer:consumer:page:deleted --host rabbit --username rabbitmq --password rabbitmq --port 5672 --exchange comitium.topic --routing-key comitium.site-dev.subsite-1.cms.1.event.page.deleted --queue-name clientA.delete_page_on_comitium_deleted_page -vvv

php app/console comitium:designer:consumer:page:state-changed --host rabbit --username rabbitmq --password rabbitmq --port 5672 --exchange comitium.topic --routing-key comitium.site-dev.subsite-1.cms.1.event.page.state_published --queue-name clientA.page_published_on_comitium_page_state_published -vvv
php app/console comitium:designer:consumer:page:state-changed --host rabbit --username rabbitmq --password rabbitmq --port 5672 --exchange comitium.topic --routing-key comitium.site-dev.subsite-1.cms.1.event.page.state_unpublished --queue-name clientA.page_unpublished_on_comitium_page_state_unpublished -vvv
php app/console comitium:designer:consumer:page:state-changed --host rabbit --username rabbitmq --password rabbitmq --port 5672 --exchange comitium.topic --routing-key comitium.site-dev.subsite-1.cms.1.event.page.state_p_uncorrected --queue-name clientA.page_p_uncorrected_on_comitium_page_state_p_uncorrected -vvv

```

Compile JS and CSS/SAS files using GULP
-
from front project container:
```npm run build --prefix=vendor/comitium5/designer-bundle ```

from designer container:
```npm run build ```