<?php
/**
 * Created by PhpStorm.
 * User: macmini1
 * Date: 16/10/14
 * Time: 12:16
 */

namespace Comitium5\DesignerBundle\Model\Traits;


trait PrivacyTrait
{

    /**
     * @var boolean
     */
    protected $public;

    /**
     * @param bool $public
     * @return PrivacyTrait
     */
    public function setPublic($public = true)
    {
        $this->public = $public;

        return $this;
    }

    /**
     * @return boolean
     */
    public function isPublic()
    {
        return $this->public;
    }

    /**
     * @param bool $private
     * @return PrivacyTrait
     */
    public function setPrivate($private = true)
    {
        $this->public = !$private;

        return $this;
    }

    /**
     * @return boolean
     */
    public function isPrivate()
    {
        return !$this->public;
    }
}