<?php

namespace Comitium5\DesignerBundle\Model\Traits;

use Comitium5\DesignerBundle\Model\Interfaces\IdentifiableInterface;

/**
 * Trait IdentifiableTrait
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Model\Traits
 */
trait IdentifiableTrait
{
    /**
     * @var int|null
     */
    protected $id;

    /**
     * @var string|null
     */
    protected $uuid;

    /**
     * @param int|null $id
     *
     * @return $this|IdentifiableInterface
     */
    public function setId(int $id = null): IdentifiableInterface
    {
        $this->id = $id;

        return $this;
    }

    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @param string|null $uuid
     *
     * @return $this|IdentifiableInterface
     */
    public function setUuid(string $uuid = null): IdentifiableInterface
    {
        $this->uuid = $uuid;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getUuid(): ?string
    {
        return $this->uuid;
    }
}
