<?php

namespace Comitium5\DesignerBundle\Model\Interfaces\Widget;

use Comitium5\DesignerBundle\Model\Interfaces\DateTimeInterface;
use Comitium5\DesignerBundle\Model\Interfaces\EnabledInterface;
use Comitium5\DesignerBundle\Model\Interfaces\HierarchicalInterface;

/**
 * Interface WidgetGroupInterface
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Model\Interfaces\Widget
 */
interface WidgetGroupInterface extends DateTimeInterface, EnabledInterface, HierarchicalInterface
{
    /**
     * @return string
     */
    public function getName(): string;

    /**
     * @param string $name
     *
     * @return WidgetGroupInterface
     */
    public function setName(string $name): WidgetGroupInterface;

    /**
     * @return string
     */
    public function getDescription(): string;

    /**
     * @param string $description
     *
     * @return WidgetGroupInterface
     */
    public function setDescription(string $description): WidgetGroupInterface;
}
