<?php

namespace Comitium5\DesignerBundle\Model\Interfaces\Page;

use Comitium5\DesignerBundle\Model\Interfaces\LocaleInterface;

/**
 * Interface PagePublisherInterface
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Model\Interfaces\Page
 */
interface PagePublisherInterface
{
    /**
     * @param DesignerPageInterface $page
     * @param LocaleInterface $locale
     */
    public function publish(DesignerPageInterface $page, LocaleInterface $locale = null): void;

    /**
     * @param DesignerPageInterface $page
     * @param LocaleInterface $locale
     */
    public function unPublish(DesignerPageInterface $page, LocaleInterface $locale = null): void;
}
