<?php

namespace Comitium5\DesignerBundle\Model\Interfaces\Layout;

use Doctrine\Common\Collections\ArrayCollection;

/**
 * Interface LayoutPageWidgetCollectionInterface
 *
 * @author Tomàs Sayes <tomas@bab-soft.com>
 * @package Comitium5\DesignerBundle\Model\Interfaces\Layout
 */
interface LayoutPageWidgetCollectionInterface
{
	/**
	 * @param LayoutPageWidgetInterface $layoutPageWidget
	 * @return self
	 */
	public function addLayoutPageWidget(LayoutPageWidgetInterface $layoutPageWidget);

	/**
	 * @param LayoutPageWidgetInterface $layoutPageWidget
	 * @return self
	 */
	public function removeLayoutPageWidget(LayoutPageWidgetInterface $layoutPageWidget);

	/**
	 * @return ArrayCollection
	 */
	public function getLayoutPageWidgets();

	/**
	 * @param ArrayCollection $layoutPageWidgets
	 * @return self
	 */
	public function setLayoutPageWidgets(ArrayCollection $layoutPageWidgets);
}