<?php

namespace Comitium5\DesignerBundle\Model\Interfaces\Layout;

use Doctrine\Common\Collections\ArrayCollection;

/**
 * Interface LayoutPageCollectionInterface
 *
 * @author Tomàs Sayes <tomas@bab-soft.com>
 * @package Comitium5\DesignerBundle\Model\Interfaces\Layout
 */
interface LayoutPageCollectionInterface
{
	/**
	 * @param LayoutPageInterface $layoutPage
	 * @return self
	 */
	public function addLayoutPage(LayoutPageInterface $layoutPage);

	/**
	 * @param LayoutPageInterface $layoutPage
	 * @return self
	 */
	public function removeLayoutPage(LayoutPageInterface $layoutPage);

	/**
	 * @return ArrayCollection
	 */
	public function getLayoutPages();

	/**
	 * @param ArrayCollection $layoutPages
	 * @return self
	 */
	public function setLayoutPages(ArrayCollection $layoutPages);
}