<?php

namespace Comitium5\DesignerBundle\Factory\Search;

use Comitium5\DesignerBundle\Factory\NormalizerFactoryInterface;
use Comitium5\DesignerBundle\ValueObjects\SearchEntityObject;

/**
 * Class SearchEntityFactory
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Factory\Search
 */
class SearchEntityFactory implements NormalizerFactoryInterface
{
    /**
     * @param array $entityData
     *
     * @return mixed|void
     */
    public function create(array $entityData): SearchEntityObject
    {
        $entity = new SearchEntityObject();

        $entity
            ->setId($entityData["id"])
            ->setTitle($entityData["title"])
            ->setPublishDate(empty($entityData["publishDate"]) ?: $entityData['publishDate'])
            ->setCreationDate(empty($entityData["creationDate"]) ?: $entityData['creationDate'])
            ->setSubsite($entityData["subSite"])
            ->setSearchable($entityData["searchable"])
            ->setContentType($entityData["contentType"]);

        if (isset($entityData['fullName'])) {
            $entity->setFullName($entityData["fullName"]);
        }

        if (isset($entityData['selfContentType'])) {
            $entity->setSelfContentType($entityData["selfContentType"]);
        }

        if (isset($entityData['indexable'])) {
            $entity->setIndexable($entityData["indexable"]);
        }

        if (isset($entityData['permalink'])) {
            $entity->setPermalink($entityData["permalink"]);
        }

        if (isset($entityData['uuid'])) {
            $entity->setUuid($entityData['uuid']);
        }

        if (isset($entityData['parent'])) {
            $entity->setParent($entityData['parent']);
        }

        if (isset($entityData['description'])) {
            $entity->setDescription($entityData['description']);
        }

        if (isset($entityData["usages"])) {
            $entity->setUsages($entityData["usages"]);
        }

        return $entity;
    }
}
