<?php

namespace Comitium5\DesignerBundle\Factory\Search\Filter;

use Elastica\Query\BoolQuery;
use Elastica\Query\Match;

/**
 * Class PublishShouldFilter
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Factory\Search\Filter
 */
class PublishShouldFilter
{
    /**
     * @var bool
     */
    private $isPublished;

    /**
     * PublishFilter constructor.
     *
     * @param bool $isPublished
     */
    public function __construct(bool $isPublished)
    {
        $this->isPublished = $isPublished;
    }

    /**
     * @param BoolQuery $boolQuery
     */
    public function __invoke(BoolQuery $boolQuery): void
    {
        $match = new Match();

        $match->setFieldQuery('searchable', $this->isPublished);

        $this->addFilter($boolQuery, $match);
    }

    /**
     * @param BoolQuery $boolQuery
     * @param Match $match
     */
    protected function addFilter(BoolQuery $boolQuery, Match $match): void
    {
        $boolQuery->addShould($match);
    }
}
