<?php

namespace Comitium5\DesignerBundle\Factory\Page;

use Comitium5\DesignerBundle\Entity\Page;
use Comitium5\DesignerBundle\Model\Interfaces\Page\DesignerPageInterface;
use Comitium5\DesignerBundle\Model\Interfaces\Page\PageFactoryInterface;

/**
 * Class PageFactory
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\PageContext\Application\Factory
 */
class DesignerPageFactory implements PageFactoryInterface
{
    /**
     * @param int $originId
     *
     * @return DesignerPageInterface
     */
    public function create(int $originId): DesignerPageInterface
    {
        $page = new Page();

        $page
            ->setOriginId($originId)
            ->setCreatedAt(new \DateTime());

        return $page;
    }
}
