<?php

namespace Comitium5\DesignerBundle\Factory\Common;

use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Templating\EngineInterface;

/**
 * Class ErrorPageResolver
 *
 * Joan Pont <joan.pont@bab-soft.com>
 * @package Comitium5\DesignerBundle\Resolver\Common
 */
class ErrorPageResponseFactory
{
    /**
     * @var string
     */
    const TEMPLATE = "Comitium5DesignerBundle:Common:error.html.twig";

    /**
     * @var EngineInterface
     */
    private $twigEngine;

    /**
     * ErrorPageResolver constructor.
     *
     * @param EngineInterface $twigEngine
     */
    public function __construct(EngineInterface $twigEngine)
    {
        $this->twigEngine = $twigEngine;
    }

    /**
     * @param $errorCode
     * @param $leadMessage
     * @param $message
     *
     * @return Response
     */
    public function __invoke($errorCode, $leadMessage, $message): Response
    {
        return new Response(
            $this->twigEngine->render(
                self::TEMPLATE,
                [
                    "errorCode"   => $errorCode,
                    "leadMessage" => $leadMessage,
                    "message"     => $message,
                ]
            )
        );
    }
}