<?php

namespace Comitium5\DesignerBundle\Factory\Asset;

use Comitium5\DesignerBundle\Entity\Asset;
use Comitium5\DesignerBundle\Factory\NormalizerFactoryInterface;
use Comitium5\DesignerBundle\Model\AssetTypes;

/**
 * Class AssetFactory
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Factory\Asset
 */
class AssetFactory implements NormalizerFactoryInterface
{
    /**
     * @param array $entity
     *
     * @return Asset
     */
    public function create(array $entity)
    {
        $asset = new Asset();

        $asset
            ->setId($entity["id"])
            ->setType($entity["type"])
            ->setUrl($entity["url"])
            ->setTitle($entity["title"])
            ->setLocaleCode($entity["locale"])
            ->setImageRelated($entity["imageRelated"])
            ->setPath($entity["path"])
            ->setEmbed(!empty($entity["metadata"]["embed"]) ? $entity["metadata"]["embed"] : "")
            ->setChildren($entity["children"])
            ->setUsages($entity["usages"])
        ;

        if ($entity["type"] === AssetTypes::IMAGE) {
            $asset
                ->setWidth($entity["metadata"]["width"])
                ->setHeight($entity["metadata"]["height"]);
        }

        return $asset;
    }
}
