<?php

namespace Comitium5\DesignerBundle\Entity;

use Symfony\Component\Security\Core\User\UserInterface;

/**
 * Class User
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Entity
 */
class User implements UserInterface
{
    /**
     * @var int
     */
    private $id;

    /**
     * @var string
     */
    private $username;

    /**
     * @var array
     */
    private $subsites;

    /**
     * @var string
     */
    private $token;

    /**
     * @var string
     */
    private $name;

    /**
     * @var string
     */
    private $surnames;

    /**
     * @var array
     */
    private $permissions;

    /**
     * User constructor.
     *
     * @param int $id
     * @param string $username
     * @param array $subsites
     * @param array $permissions
     * @param string $name
     * @param string $surnames
     * @param string $token
     */
    public function __construct(
        int $id,
        string $username,
        array $subsites,
        array $permissions,
        string $name,
        string $surnames,
        string $token
    ) {
        $this->id          = $id;
        $this->username    = $username;
        $this->subsites    = $this->normalizeSubsites($subsites);
        $this->token       = $token;
        $this->name        = $name;
        $this->surnames    = $surnames;
        $this->permissions = $permissions;
    }

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    public function getRoles()
    {
        return ['ROLE_USER'];
    }

    public function getPassword()
    {
    }

    public function getSalt()
    {
    }

    public function getUsername()
    {
        return $this->username;
    }

    public function eraseCredentials()
    {
    }

    /**
     * @return mixed
     */
    public function getSubsites()
    {
        return $this->subsites;
    }

    /**
     * @param array $subsites
     *
     * @return Subsite[]
     */
    private function normalizeSubsites(array $subsites)
    {
        foreach ($subsites as &$subsite) {
            $entity = new Subsite();

            $entity
                ->setId($subsite["id"])
                ->setName($subsite["name"])
                ->setAcronym($subsite["acronym"]);

            $subsite = $entity;
        }

        return $subsites;
    }

    /**
     * @return string
     */
    public function getToken(): string
    {
        return $this->token;
    }

    /**
     * @return array
     */
    public function getPermissions(): array
    {
        return $this->permissions;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @return string
     */
    public function getSurnames(): string
    {
        return $this->surnames;
    }
}
