<?php

namespace Comitium5\DesignerBundle\Entity;


use Comitium5\DesignerBundle\Model\Interfaces\Layout\LayoutPageInterface;
use Comitium5\DesignerBundle\Model\Traits\Layout\LayoutPageWidgetCollectionTrait;
use Comitium5\DesignerBundle\Model\Traits\Layout\LayoutRelationTrait;
use Comitium5\DesignerBundle\Model\Traits\Page\PageRelationTrait;
use Comitium5\DesignerBundle\Model\Traits\SortableTrait;
use Comitium5\DesignerBundle\Model\Traits\TmpIdentifierTrait;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * Class LayoutPage
 *
 * @author Tomàs Sayes <tomas@bab-soft.com>
 * @package Comitium5\DesignerBundle\Entity
 */
class LayoutPage extends AbstractSerializeEntity implements LayoutPageInterface
{
    use SortableTrait,
        LayoutRelationTrait,
        PageRelationTrait,
        LayoutPageWidgetCollectionTrait,
        TmpIdentifierTrait;

    /**
     * @var \DateTime
     */
    private $startAt;

    /**
     * @var \DateTime
     */
    private $endAt;

	/**
	 * @var string
	 */
	protected $html;

    public function __construct()
    {
        parent::__construct();
        $this->layoutPageWidgets = new ArrayCollection();
    }

    /**
     * @return \DateTime
     */
    public function getStartAt()
    {
        return $this->startAt;
    }

    /**
     * @param \DateTime $startAt
     * @return self
     */
    public function setStartAt($startAt)
    {
        $this->startAt = $startAt;
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getEndAt()
    {
        return $this->endAt;
    }

    /**
     * @param \DateTime $endAt
     * @return self
     */
    public function setEndAt($endAt)
    {
        $this->endAt = $endAt;
        return $this;
    }

	/**
	 * @return string
	 */
	public function getHtml()
	{
		return $this->html;
	}

    /**
     * @param string $html
     * @return self
     */
	public function setHtml(string $html)
	{
		$this->html = $html;
		return $this;
	}

    /**
     * @access public
     * @param string[] $allowed optional
     * @param string[] $denied optional
     * @param string[] $entityFields optional
     * @return mixed[]
     */
    public function toArray($allowed = array(), $denied = array(), $entityFields = array('layoutPageWidgets'))
    {
        return parent::toArray($allowed, $denied, $entityFields);
    }
}
